/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.ZoomControl;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraControl;
import androidx.camera.core.impl.Config;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;

@RequiresApi(value=21)
final class CropRegionZoomImpl
implements ZoomControl.ZoomImpl {
    public static final float MIN_DIGITAL_ZOOM = 1.0f;
    private final CameraCharacteristicsCompat mCameraCharacteristics;
    private Rect mCurrentCropRect = null;
    private CallbackToFutureAdapter.Completer<Void> mPendingZoomRatioCompleter;
    private Rect mPendingZoomCropRegion = null;

    CropRegionZoomImpl(@NonNull CameraCharacteristicsCompat cameraCharacteristics) {
        this.mCameraCharacteristics = cameraCharacteristics;
    }

    @Override
    public float getMinZoom() {
        return 1.0f;
    }

    @Override
    public float getMaxZoom() {
        Float maxZoom = (Float)this.mCameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
        if (maxZoom == null) {
            return 1.0f;
        }
        if (maxZoom.floatValue() < this.getMinZoom()) {
            return this.getMinZoom();
        }
        return maxZoom.floatValue();
    }

    @Override
    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    public void addRequestOption(@NonNull Camera2ImplConfig.Builder builder) {
        if (this.mCurrentCropRect != null) {
            builder.setCaptureRequestOptionWithPriority(CaptureRequest.SCALER_CROP_REGION, this.mCurrentCropRect, Config.OptionPriority.REQUIRED);
        }
    }

    @Override
    public void resetZoom() {
        this.mPendingZoomCropRegion = null;
        this.mCurrentCropRect = null;
        if (this.mPendingZoomRatioCompleter != null) {
            this.mPendingZoomRatioCompleter.setException((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
            this.mPendingZoomRatioCompleter = null;
        }
    }

    private Rect getSensorRect() {
        return (Rect)Preconditions.checkNotNull((Object)((Rect)this.mCameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE)));
    }

    @NonNull
    private static Rect getCropRectByRatio(@NonNull Rect sensorRect, float ratio) {
        float cropWidth = (float)sensorRect.width() / ratio;
        float cropHeight = (float)sensorRect.height() / ratio;
        float left = ((float)sensorRect.width() - cropWidth) / 2.0f;
        float top = ((float)sensorRect.height() - cropHeight) / 2.0f;
        return new Rect((int)left, (int)top, (int)(left + cropWidth), (int)(top + cropHeight));
    }

    @Override
    public void setZoomRatio(float zoomRatio, @NonNull CallbackToFutureAdapter.Completer<Void> completer) {
        Rect sensorRect = this.getSensorRect();
        this.mCurrentCropRect = CropRegionZoomImpl.getCropRectByRatio(sensorRect, zoomRatio);
        if (this.mPendingZoomRatioCompleter != null) {
            this.mPendingZoomRatioCompleter.setException((Throwable)new CameraControl.OperationCanceledException("There is a new zoomRatio being set"));
        }
        this.mPendingZoomCropRegion = this.mCurrentCropRect;
        this.mPendingZoomRatioCompleter = completer;
    }

    @Override
    public void onCaptureResult(@NonNull TotalCaptureResult captureResult) {
        if (this.mPendingZoomRatioCompleter != null) {
            Rect cropRect;
            CaptureRequest request = captureResult.getRequest();
            Rect rect = cropRect = request == null ? null : (Rect)request.get(CaptureRequest.SCALER_CROP_REGION);
            if (this.mPendingZoomCropRegion != null && this.mPendingZoomCropRegion.equals((Object)cropRect)) {
                this.mPendingZoomRatioCompleter.set(null);
                this.mPendingZoomRatioCompleter = null;
                this.mPendingZoomCropRegion = null;
            }
        }
    }

    @Override
    @NonNull
    public Rect getCropSensorRegion() {
        return this.mCurrentCropRect != null ? this.mCurrentCropRect : this.getSensorRect();
    }
}

