/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.os.Handler;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.CaptureSessionRepository;
import androidx.camera.camera2.internal.SynchronizedCaptureSessionImpl;
import androidx.camera.camera2.internal.compat.CameraCaptureSessionCompat;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompat;
import androidx.camera.camera2.internal.compat.params.SessionConfigurationCompat;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.Quirks;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

@RequiresApi(value=21)
public interface SynchronizedCaptureSession {
    @NonNull
    public CameraDevice getDevice();

    @NonNull
    public StateCallback getStateCallback();

    @Nullable
    public Surface getInputSurface();

    @NonNull
    public ListenableFuture<Void> getOpeningBlocker();

    @NonNull
    public CameraCaptureSessionCompat toCameraCaptureSessionCompat();

    public int captureSingleRequest(@NonNull CaptureRequest var1, @NonNull CameraCaptureSession.CaptureCallback var2) throws CameraAccessException;

    public int captureBurstRequests(@NonNull List<CaptureRequest> var1, @NonNull CameraCaptureSession.CaptureCallback var2) throws CameraAccessException;

    public int setSingleRepeatingRequest(@NonNull CaptureRequest var1, @NonNull CameraCaptureSession.CaptureCallback var2) throws CameraAccessException;

    public int setRepeatingBurstRequests(@NonNull List<CaptureRequest> var1, @NonNull CameraCaptureSession.CaptureCallback var2) throws CameraAccessException;

    public int captureSingleRequest(@NonNull CaptureRequest var1, @NonNull Executor var2, @NonNull CameraCaptureSession.CaptureCallback var3) throws CameraAccessException;

    public int captureBurstRequests(@NonNull List<CaptureRequest> var1, @NonNull Executor var2, @NonNull CameraCaptureSession.CaptureCallback var3) throws CameraAccessException;

    public int setSingleRepeatingRequest(@NonNull CaptureRequest var1, @NonNull Executor var2, @NonNull CameraCaptureSession.CaptureCallback var3) throws CameraAccessException;

    public int setRepeatingBurstRequests(@NonNull List<CaptureRequest> var1, @NonNull Executor var2, @NonNull CameraCaptureSession.CaptureCallback var3) throws CameraAccessException;

    public void stopRepeating() throws CameraAccessException;

    public void abortCaptures() throws CameraAccessException;

    public void close();

    public void finishClose();

    public void onCameraDeviceError(int var1);

    public static class OpenerBuilder {
        private final Executor mExecutor;
        private final ScheduledExecutorService mScheduledExecutorService;
        private final Handler mCompatHandler;
        private final CaptureSessionRepository mCaptureSessionRepository;
        private final Quirks mCameraQuirks;
        private final Quirks mDeviceQuirks;

        OpenerBuilder(@NonNull Executor executor, @NonNull ScheduledExecutorService scheduledExecutorService, @NonNull Handler compatHandler, @NonNull CaptureSessionRepository captureSessionRepository, @NonNull Quirks cameraQuirks, @NonNull Quirks deviceQuirks) {
            this.mExecutor = executor;
            this.mScheduledExecutorService = scheduledExecutorService;
            this.mCompatHandler = compatHandler;
            this.mCaptureSessionRepository = captureSessionRepository;
            this.mCameraQuirks = cameraQuirks;
            this.mDeviceQuirks = deviceQuirks;
        }

        @NonNull
        Opener build() {
            return new SynchronizedCaptureSessionImpl(this.mCameraQuirks, this.mDeviceQuirks, this.mCaptureSessionRepository, this.mExecutor, this.mScheduledExecutorService, this.mCompatHandler);
        }
    }

    public static interface Opener {
        @NonNull
        public ListenableFuture<Void> openCaptureSession(@NonNull CameraDevice var1, @NonNull SessionConfigurationCompat var2, @NonNull List<DeferrableSurface> var3);

        @NonNull
        public SessionConfigurationCompat createSessionConfigurationCompat(int var1, @NonNull List<OutputConfigurationCompat> var2, @NonNull StateCallback var3);

        @NonNull
        public ListenableFuture<List<Surface>> startWithDeferrableSurface(@NonNull List<DeferrableSurface> var1, long var2);

        @NonNull
        public Executor getExecutor();

        public boolean stop();
    }

    public static abstract class StateCallback {
        void onReady(@NonNull SynchronizedCaptureSession session) {
        }

        void onActive(@NonNull SynchronizedCaptureSession session) {
        }

        @RequiresApi(api=26)
        void onCaptureQueueEmpty(@NonNull SynchronizedCaptureSession session) {
        }

        @RequiresApi(api=23)
        void onSurfacePrepared(@NonNull SynchronizedCaptureSession session, @NonNull Surface surface) {
        }

        void onConfigured(@NonNull SynchronizedCaptureSession session) {
        }

        public void onConfigureFailed(@NonNull SynchronizedCaptureSession session) {
        }

        public void onClosed(@NonNull SynchronizedCaptureSession session) {
        }

        void onSessionFinished(@NonNull SynchronizedCaptureSession session) {
        }
    }
}

