/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import android.hardware.camera2.CaptureRequest;
import android.util.Range;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.compat.quirk.AeFpsRangeLegacyQuirk;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.Quirks;

@RequiresApi(value=21)
public class AeFpsRange {
    @Nullable
    private final Range<Integer> mAeTargetFpsRange;

    public AeFpsRange(@NonNull Quirks quirks) {
        AeFpsRangeLegacyQuirk quirk = (AeFpsRangeLegacyQuirk)quirks.get(AeFpsRangeLegacyQuirk.class);
        this.mAeTargetFpsRange = quirk == null ? null : quirk.getRange();
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    public void addAeFpsRangeOptions(@NonNull Camera2ImplConfig.Builder configBuilder) {
        if (this.mAeTargetFpsRange != null) {
            configBuilder.setCaptureRequestOptionWithPriority(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, this.mAeTargetFpsRange, Config.OptionPriority.REQUIRED);
        }
    }
}

