/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.Camera2CaptureCallbacks;
import androidx.camera.camera2.internal.compat.quirk.CaptureSessionStuckQuirk;
import androidx.camera.camera2.internal.compat.quirk.IncorrectCaptureStateQuirk;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public class RequestMonitor {
    private final boolean mQuirkEnabled;
    private final List<ListenableFuture<Void>> mRequestTasks = Collections.synchronizedList(new ArrayList());

    public RequestMonitor(@NonNull Quirks cameraQuirks) {
        this.mQuirkEnabled = cameraQuirks.contains(CaptureSessionStuckQuirk.class) || cameraQuirks.contains(IncorrectCaptureStateQuirk.class);
    }

    public boolean shouldMonitorRequest() {
        return this.mQuirkEnabled;
    }

    @NonNull
    public ListenableFuture<Void> getRequestsProcessedFuture() {
        if (this.mRequestTasks.isEmpty()) {
            return Futures.immediateFuture(null);
        }
        return Futures.nonCancellationPropagating((ListenableFuture)Futures.transform((ListenableFuture)Futures.successfulAsList(new ArrayList<ListenableFuture<Void>>(this.mRequestTasks)), input -> null, (Executor)CameraXExecutors.directExecutor()));
    }

    public int setSingleRepeatingRequest(@NonNull CaptureRequest request, @NonNull CameraCaptureSession.CaptureCallback listener, @NonNull SingleRequest singleRequest) throws CameraAccessException {
        if (this.shouldMonitorRequest()) {
            listener = Camera2CaptureCallbacks.createComboCallback(this.createMonitorListener(), listener);
        }
        return singleRequest.run(request, listener);
    }

    public int captureBurstRequests(@NonNull List<CaptureRequest> requests, @NonNull CameraCaptureSession.CaptureCallback listener, @NonNull MultiRequest multiRequest) throws CameraAccessException {
        if (this.shouldMonitorRequest()) {
            listener = Camera2CaptureCallbacks.createComboCallback(this.createMonitorListener(), listener);
        }
        return multiRequest.run(requests, listener);
    }

    private CameraCaptureSession.CaptureCallback createMonitorListener() {
        RequestCompleteListener completeListener = new RequestCompleteListener();
        ListenableFuture<Void> future = completeListener.mStartRequestFuture;
        this.mRequestTasks.add(future);
        future.addListener(() -> this.mRequestTasks.remove(future), CameraXExecutors.directExecutor());
        return completeListener;
    }

    public void stop() {
        LinkedList<ListenableFuture<Void>> tasks = new LinkedList<ListenableFuture<Void>>(this.mRequestTasks);
        while (!tasks.isEmpty()) {
            Objects.requireNonNull(tasks.poll()).cancel(true);
        }
    }

    @FunctionalInterface
    public static interface SingleRequest {
        public int run(@NonNull CaptureRequest var1, @NonNull CameraCaptureSession.CaptureCallback var2) throws CameraAccessException;
    }

    @FunctionalInterface
    public static interface MultiRequest {
        public int run(@NonNull List<CaptureRequest> var1, @NonNull CameraCaptureSession.CaptureCallback var2) throws CameraAccessException;
    }

    static class RequestCompleteListener
    extends CameraCaptureSession.CaptureCallback {
        @NonNull
        final ListenableFuture<Void> mStartRequestFuture = CallbackToFutureAdapter.getFuture(completer -> {
            this.mStartRequestCompleter = completer;
            return "RequestCompleteListener[" + (Object)((Object)this) + "]";
        });
        CallbackToFutureAdapter.Completer<Void> mStartRequestCompleter;

        RequestCompleteListener() {
        }

        public void onCaptureStarted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, long timestamp, long frameNumber) {
            this.completeFuture();
        }

        public void onCaptureSequenceAborted(@NonNull CameraCaptureSession session, int sequenceId) {
            this.completeFuture();
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            this.completeFuture();
        }

        public void onCaptureFailed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureFailure failure) {
            this.completeFuture();
        }

        public void onCaptureSequenceCompleted(@NonNull CameraCaptureSession session, int sequenceId, long frameNumber) {
            this.completeFuture();
        }

        private void completeFuture() {
            if (this.mStartRequestCompleter != null) {
                this.mStartRequestCompleter.set(null);
                this.mStartRequestCompleter = null;
            }
        }
    }
}

