/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraCaptureCallback;
import androidx.camera.core.CameraCaptureFailure;
import androidx.camera.core.CameraCaptureResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CameraCaptureCallbacks {
    private CameraCaptureCallbacks() {
    }

    public static CameraCaptureCallback createNoOpCallback() {
        return new NoOpCameraCaptureCallback();
    }

    static CameraCaptureCallback createComboCallback(List<CameraCaptureCallback> callbacks) {
        if (callbacks.isEmpty()) {
            return CameraCaptureCallbacks.createNoOpCallback();
        }
        if (callbacks.size() == 1) {
            return callbacks.get(0);
        }
        return new ComboCameraCaptureCallback(callbacks);
    }

    public static CameraCaptureCallback createComboCallback(CameraCaptureCallback ... callbacks) {
        return CameraCaptureCallbacks.createComboCallback(Arrays.asList(callbacks));
    }

    public static final class ComboCameraCaptureCallback
    extends CameraCaptureCallback {
        private final List<CameraCaptureCallback> mCallbacks = new ArrayList<CameraCaptureCallback>();

        ComboCameraCaptureCallback(List<CameraCaptureCallback> callbacks) {
            for (CameraCaptureCallback callback : callbacks) {
                if (callback instanceof NoOpCameraCaptureCallback) continue;
                this.mCallbacks.add(callback);
            }
        }

        @Override
        public void onCaptureCompleted(@NonNull CameraCaptureResult result) {
            for (CameraCaptureCallback callback : this.mCallbacks) {
                callback.onCaptureCompleted(result);
            }
        }

        @Override
        public void onCaptureFailed(@NonNull CameraCaptureFailure failure) {
            for (CameraCaptureCallback callback : this.mCallbacks) {
                callback.onCaptureFailed(failure);
            }
        }

        @Override
        public void onCaptureCancelled() {
            for (CameraCaptureCallback callback : this.mCallbacks) {
                callback.onCaptureCancelled();
            }
        }

        @NonNull
        public List<CameraCaptureCallback> getCallbacks() {
            return this.mCallbacks;
        }
    }

    static final class NoOpCameraCaptureCallback
    extends CameraCaptureCallback {
        NoOpCameraCaptureCallback() {
        }

        @Override
        public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
        }

        @Override
        public void onCaptureFailed(@NonNull CameraCaptureFailure failure) {
        }
    }
}

