/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class DeferrableSurface {
    private static final boolean DEBUG = false;
    protected static final String TAG = "DeferrableSurface";
    private static AtomicInteger sSurfaceCount = new AtomicInteger(0);
    @GuardedBy(value="mLock")
    private int mAttachedCount = 0;
    private volatile boolean mClosed = false;
    @Nullable
    @GuardedBy(value="mLock")
    private OnSurfaceDetachedListener mOnSurfaceDetachedListener = null;
    @Nullable
    @GuardedBy(value="mLock")
    private Executor mListenerExecutor = null;
    private final Object mLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public final ListenableFuture<Surface> getSurface() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return Futures.immediateFailedFuture(new SurfaceClosedException("DeferrableSurface already closed.", this));
            }
            return this.provideSurface();
        }
    }

    abstract ListenableFuture<Surface> provideSurface();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySurfaceAttached() {
        Object object = this.mLock;
        synchronized (object) {
            ++this.mAttachedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        Object object = this.mLock;
        synchronized (object) {
            this.mClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySurfaceDetached() {
        OnSurfaceDetachedListener listener = null;
        Executor listenerExecutor = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAttachedCount == 0) {
                throw new IllegalStateException("Detaching occurs more times than attaching");
            }
            --this.mAttachedCount;
            if (this.mAttachedCount == 0) {
                listener = this.mOnSurfaceDetachedListener;
                listenerExecutor = this.mListenerExecutor;
            }
        }
        if (listener != null && listenerExecutor != null) {
            DeferrableSurface.callOnSurfaceDetachedListener(listener, listenerExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnSurfaceDetachedListener(@NonNull Executor executor, @NonNull OnSurfaceDetachedListener listener) {
        Preconditions.checkNotNull((Object)executor);
        Preconditions.checkNotNull((Object)listener);
        boolean shouldCallListenerNow = false;
        Object object = this.mLock;
        synchronized (object) {
            this.mOnSurfaceDetachedListener = listener;
            this.mListenerExecutor = executor;
            if (this.mAttachedCount == 0) {
                shouldCallListenerNow = true;
            }
        }
        if (shouldCallListenerNow) {
            DeferrableSurface.callOnSurfaceDetachedListener(listener, executor);
        }
    }

    private static void callOnSurfaceDetachedListener(final @NonNull OnSurfaceDetachedListener listener, @NonNull Executor executor) {
        Preconditions.checkNotNull((Object)executor);
        Preconditions.checkNotNull((Object)listener);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                listener.onSurfaceDetached();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    public int getAttachedCount() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAttachedCount;
        }
    }

    public static interface OnSurfaceDetachedListener {
        public void onSurfaceDetached();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class SurfaceClosedException
    extends Exception {
        DeferrableSurface mDeferrableSurface;

        public SurfaceClosedException(@NonNull String s, @NonNull Throwable e, @NonNull DeferrableSurface surface) {
            super(s, e);
            this.mDeferrableSurface = surface;
        }

        public SurfaceClosedException(@NonNull String s, @NonNull DeferrableSurface surface) {
            super(s);
            this.mDeferrableSurface = surface;
        }

        @NonNull
        public DeferrableSurface getDeferrableSurface() {
            return this.mDeferrableSurface;
        }
    }
}

