/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.media.ImageReader;
import android.util.Log;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.core.AndroidImageReaderProxy;
import androidx.camera.core.CameraDeviceSurfaceManager;
import androidx.camera.core.DeviceProperties;
import androidx.camera.core.ForwardingImageReaderListener;
import androidx.camera.core.ImageReaderProxy;
import androidx.camera.core.QueuedImageReaderProxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ImageReaderProxys {
    private static final String TAG = ImageReaderProxys.class.getSimpleName();
    private static final int SHARED_IMAGE_FORMAT = 35;
    private static final int SHARED_MAX_IMAGES = 8;
    static final List<QueuedImageReaderProxy> sSharedImageReaderProxys = new ArrayList<QueuedImageReaderProxy>();
    private static Set<DeviceProperties> sSharedReaderWhitelist;
    private static ImageReaderProxy sSharedImageReader;

    private ImageReaderProxys() {
    }

    @NonNull
    static ImageReaderProxy createCompatibleReader(CameraDeviceSurfaceManager surfaceManager, String cameraId, int width, int height, int format, int maxImages, Executor executor) {
        if (ImageReaderProxys.inSharedReaderWhitelist(DeviceProperties.create())) {
            return ImageReaderProxys.createSharedReader(surfaceManager, cameraId, width, height, format, maxImages, executor);
        }
        return ImageReaderProxys.createIsolatedReader(width, height, format, maxImages);
    }

    @NonNull
    public static ImageReaderProxy createIsolatedReader(int width, int height, int format, int maxImages) {
        ImageReader imageReader = ImageReader.newInstance((int)width, (int)height, (int)format, (int)maxImages);
        return new AndroidImageReaderProxy(imageReader);
    }

    @NonNull
    public static ImageReaderProxy createSharedReader(@NonNull CameraDeviceSurfaceManager surfaceManager, @NonNull String cameraId, int width, int height, int format, int maxImages, @NonNull Executor executor) {
        if (sSharedImageReader == null) {
            Size resolution = surfaceManager.getMaxOutputSize(cameraId, 35);
            Log.d((String)TAG, (String)("Resolution of base ImageReader: " + resolution));
            sSharedImageReader = new AndroidImageReaderProxy(ImageReader.newInstance((int)resolution.getWidth(), (int)resolution.getHeight(), (int)35, (int)8));
        }
        Log.d((String)TAG, (String)("Resolution of forked ImageReader: " + new Size(width, height)));
        QueuedImageReaderProxy imageReaderProxy = new QueuedImageReaderProxy(width, height, format, maxImages, sSharedImageReader.getSurface());
        sSharedImageReaderProxys.add(imageReaderProxy);
        sSharedImageReader.setOnImageAvailableListener((ImageReaderProxy.OnImageAvailableListener)new ForwardingImageReaderListener(sSharedImageReaderProxys), executor);
        imageReaderProxy.addOnReaderCloseListener(new QueuedImageReaderProxy.OnReaderCloseListener(){

            @Override
            public void onReaderClose(ImageReaderProxy reader) {
                sSharedImageReaderProxys.remove(reader);
                if (sSharedImageReaderProxys.isEmpty()) {
                    ImageReaderProxys.clearSharedReaders();
                }
            }
        });
        return imageReaderProxy;
    }

    static boolean inSharedReaderWhitelist(DeviceProperties device) {
        if (sSharedReaderWhitelist == null) {
            sSharedReaderWhitelist = new HashSet<DeviceProperties>();
            for (int sdkVersion = 21; sdkVersion <= 27; ++sdkVersion) {
            }
        }
        return sSharedReaderWhitelist.contains(device);
    }

    static void clearSharedReaders() {
        sSharedImageReaderProxys.clear();
        sSharedImageReader.close();
        sSharedImageReader = null;
    }
}

