/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraDeviceConfig;
import androidx.camera.core.CameraIdFilter;
import androidx.camera.core.CaptureConfig;
import androidx.camera.core.CaptureProcessor;
import androidx.camera.core.Config;
import androidx.camera.core.ImageInfoProcessor;
import androidx.camera.core.ImageOutputConfig;
import androidx.camera.core.OptionsBundle;
import androidx.camera.core.Preview;
import androidx.camera.core.SessionConfig;
import androidx.camera.core.ThreadConfig;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseConfig;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class PreviewConfig
implements UseCaseConfig<Preview>,
ImageOutputConfig,
CameraDeviceConfig,
ThreadConfig {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    static final Config.Option<ImageInfoProcessor> IMAGE_INFO_PROCESSOR = Config.Option.create("camerax.core.preview.imageInfoProcessor", ImageInfoProcessor.class);
    static final Config.Option<CaptureProcessor> OPTION_PREVIEW_CAPTURE_PROCESSOR = Config.Option.create("camerax.core.preview.captureProcessor", CaptureProcessor.class);
    private final OptionsBundle mConfig;

    PreviewConfig(OptionsBundle config) {
        this.mConfig = config;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean containsOption(@NonNull Config.Option<?> id) {
        return this.mConfig.containsOption(id);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id) {
        return this.mConfig.retrieveOption(id);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id, @Nullable ValueT valueIfMissing) {
        return this.mConfig.retrieveOption(id, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void findOptions(@NonNull String idStem, @NonNull Config.OptionMatcher matcher) {
        this.mConfig.findOptions(idStem, matcher);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Set<Config.Option<?>> listOptions() {
        return this.mConfig.listOptions();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Class<Preview> getTargetClass(@Nullable Class<Preview> valueIfMissing) {
        Class<Preview> storedClass = this.retrieveOption(OPTION_TARGET_CLASS, valueIfMissing);
        return storedClass;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Class<Preview> getTargetClass() {
        Class storedClass = (Class)this.retrieveOption(OPTION_TARGET_CLASS);
        return storedClass;
    }

    @Override
    @Nullable
    public String getTargetName(@Nullable String valueIfMissing) {
        return this.retrieveOption(OPTION_TARGET_NAME, valueIfMissing);
    }

    @Override
    @NonNull
    public String getTargetName() {
        return (String)this.retrieveOption(OPTION_TARGET_NAME);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Integer getLensFacing(@Nullable Integer valueIfMissing) {
        return this.retrieveOption(OPTION_LENS_FACING, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getLensFacing() {
        return (Integer)this.retrieveOption(OPTION_LENS_FACING);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CameraIdFilter getCameraIdFilter(@Nullable CameraIdFilter valueIfMissing) {
        return this.retrieveOption(OPTION_CAMERA_ID_FILTER, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public CameraIdFilter getCameraIdFilter() {
        return (CameraIdFilter)this.retrieveOption(OPTION_CAMERA_ID_FILTER);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Rational getTargetAspectRatioCustom(@Nullable Rational valueIfMissing) {
        return this.retrieveOption(OPTION_TARGET_ASPECT_RATIO_CUSTOM, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Rational getTargetAspectRatioCustom() {
        return (Rational)this.retrieveOption(OPTION_TARGET_ASPECT_RATIO_CUSTOM);
    }

    @Override
    public boolean hasTargetAspectRatio() {
        return this.containsOption(OPTION_TARGET_ASPECT_RATIO);
    }

    @Override
    public int getTargetAspectRatio() {
        return (Integer)this.retrieveOption(OPTION_TARGET_ASPECT_RATIO);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getTargetRotation(int valueIfMissing) {
        return this.retrieveOption(OPTION_TARGET_ROTATION, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getTargetRotation() {
        return (Integer)this.retrieveOption(OPTION_TARGET_ROTATION);
    }

    @Override
    @Nullable
    public Size getTargetResolution(@Nullable Size valueIfMissing) {
        return this.retrieveOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION, valueIfMissing);
    }

    @Override
    @NonNull
    public Size getTargetResolution() {
        return this.retrieveOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION);
    }

    @Override
    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Size getDefaultResolution(@Nullable Size valueIfMissing) {
        return this.retrieveOption(ImageOutputConfig.OPTION_DEFAULT_RESOLUTION, valueIfMissing);
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Size getDefaultResolution() {
        return this.retrieveOption(ImageOutputConfig.OPTION_DEFAULT_RESOLUTION);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Size getMaxResolution(@Nullable Size valueIfMissing) {
        return this.retrieveOption(OPTION_MAX_RESOLUTION, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Size getMaxResolution() {
        return (Size)this.retrieveOption(OPTION_MAX_RESOLUTION);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public List<Pair<Integer, Size[]>> getSupportedResolutions(@Nullable List<Pair<Integer, Size[]>> valueIfMissing) {
        return this.retrieveOption(OPTION_SUPPORTED_RESOLUTIONS, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public List<Pair<Integer, Size[]>> getSupportedResolutions() {
        return (List)this.retrieveOption(OPTION_SUPPORTED_RESOLUTIONS);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Executor getBackgroundExecutor(@Nullable Executor valueIfMissing) {
        return this.retrieveOption(OPTION_BACKGROUND_EXECUTOR, valueIfMissing);
    }

    @Override
    @NonNull
    public Executor getBackgroundExecutor() {
        return (Executor)this.retrieveOption(OPTION_BACKGROUND_EXECUTOR);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public SessionConfig getDefaultSessionConfig(@Nullable SessionConfig valueIfMissing) {
        return this.retrieveOption(OPTION_DEFAULT_SESSION_CONFIG, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public SessionConfig getDefaultSessionConfig() {
        return (SessionConfig)this.retrieveOption(OPTION_DEFAULT_SESSION_CONFIG);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public SessionConfig.OptionUnpacker getSessionOptionUnpacker(@Nullable SessionConfig.OptionUnpacker valueIfMissing) {
        return this.retrieveOption(OPTION_SESSION_CONFIG_UNPACKER, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public SessionConfig.OptionUnpacker getSessionOptionUnpacker() {
        return (SessionConfig.OptionUnpacker)this.retrieveOption(OPTION_SESSION_CONFIG_UNPACKER);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CaptureConfig getDefaultCaptureConfig(@Nullable CaptureConfig valueIfMissing) {
        return this.retrieveOption(OPTION_DEFAULT_CAPTURE_CONFIG, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public CaptureConfig getDefaultCaptureConfig() {
        return (CaptureConfig)this.retrieveOption(OPTION_DEFAULT_CAPTURE_CONFIG);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CaptureConfig.OptionUnpacker getCaptureOptionUnpacker(@Nullable CaptureConfig.OptionUnpacker valueIfMissing) {
        return this.retrieveOption(OPTION_CAPTURE_CONFIG_UNPACKER, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public CaptureConfig.OptionUnpacker getCaptureOptionUnpacker() {
        return (CaptureConfig.OptionUnpacker)this.retrieveOption(OPTION_CAPTURE_CONFIG_UNPACKER);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getSurfaceOccupancyPriority(int valueIfMissing) {
        return this.retrieveOption(OPTION_SURFACE_OCCUPANCY_PRIORITY, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getSurfaceOccupancyPriority() {
        return (Integer)this.retrieveOption(OPTION_SURFACE_OCCUPANCY_PRIORITY);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public UseCase.EventCallback getUseCaseEventCallback(@Nullable UseCase.EventCallback valueIfMissing) {
        return this.retrieveOption(OPTION_USE_CASE_EVENT_CALLBACK, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public UseCase.EventCallback getUseCaseEventCallback() {
        return (UseCase.EventCallback)this.retrieveOption(OPTION_USE_CASE_EVENT_CALLBACK);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    ImageInfoProcessor getImageInfoProcessor(@Nullable ImageInfoProcessor valueIfMissing) {
        return this.retrieveOption(IMAGE_INFO_PROCESSOR, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    ImageInfoProcessor getImageInfoProcessor() {
        return this.retrieveOption(IMAGE_INFO_PROCESSOR);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CaptureProcessor getCaptureProcessor(@Nullable CaptureProcessor valueIfMissing) {
        return this.retrieveOption(OPTION_PREVIEW_CAPTURE_PROCESSOR, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public CaptureProcessor getCaptureProcessor() {
        return this.retrieveOption(OPTION_PREVIEW_CAPTURE_PROCESSOR);
    }
}

