/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageProxyBundle;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class SingleImageProxyBundle
implements ImageProxyBundle {
    private final int mCaptureId;
    private final ImageProxy mImageProxy;

    public SingleImageProxyBundle(@NonNull ImageProxy imageProxy) {
        ImageInfo imageInfo = imageProxy.getImageInfo();
        if (imageInfo == null) {
            throw new IllegalArgumentException("ImageProxy has no associated ImageInfo");
        }
        Object tag = imageInfo.getTag();
        if (tag == null) {
            throw new IllegalArgumentException("ImageProxy has no associated tag");
        }
        if (!(tag instanceof Integer)) {
            throw new IllegalArgumentException("ImageProxy has tag that isn't an integer");
        }
        this.mCaptureId = (Integer)tag;
        this.mImageProxy = imageProxy;
    }

    SingleImageProxyBundle(@NonNull ImageProxy imageProxy, int captureId) {
        this.mCaptureId = captureId;
        this.mImageProxy = imageProxy;
    }

    void close() {
        this.mImageProxy.close();
    }

    @Override
    @NonNull
    public ListenableFuture<ImageProxy> getImageProxy(int captureId) {
        if (captureId != this.mCaptureId) {
            return Futures.immediateFailedFuture(new IllegalArgumentException("Capture id does not exist in the bundle"));
        }
        return Futures.immediateFuture(this.mImageProxy);
    }

    @Override
    @NonNull
    public List<Integer> getCaptureIds() {
        return Collections.singletonList(this.mCaptureId);
    }
}

