/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.RestrictTo;
import androidx.camera.core.AutoValue_SurfaceConfig;
import com.google.auto.value.AutoValue;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@AutoValue
public abstract class SurfaceConfig {
    SurfaceConfig() {
    }

    public static SurfaceConfig create(ConfigType type, ConfigSize size) {
        return new AutoValue_SurfaceConfig(type, size);
    }

    public abstract ConfigType getConfigType();

    public abstract ConfigSize getConfigSize();

    public final boolean isSupported(SurfaceConfig surfaceConfig) {
        boolean isSupported = false;
        ConfigType configType = surfaceConfig.getConfigType();
        ConfigSize configSize = surfaceConfig.getConfigSize();
        if (configSize.getId() <= this.getConfigSize().getId() && configType == this.getConfigType()) {
            isSupported = true;
        }
        return isSupported;
    }

    public static enum ConfigSize {
        ANALYSIS(0),
        PREVIEW(1),
        RECORD(2),
        MAXIMUM(3),
        NOT_SUPPORT(4);

        final int mId;

        private ConfigSize(int id) {
            this.mId = id;
        }

        int getId() {
            return this.mId;
        }
    }

    public static enum ConfigType {
        PRIV,
        YUV,
        JPEG,
        RAW;

    }
}

