/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.GuardedBy;
import androidx.camera.core.UseCase;
import androidx.camera.core.UseCaseGroup;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;

final class UseCaseGroupLifecycleController
implements LifecycleObserver {
    private final Object mUseCaseGroupLock = new Object();
    @GuardedBy(value="mUseCaseGroupLock")
    private final UseCaseGroup mUseCaseGroup;
    private final Lifecycle mLifecycle;

    UseCaseGroupLifecycleController(Lifecycle lifecycle) {
        this(lifecycle, new UseCaseGroup());
    }

    UseCaseGroupLifecycleController(Lifecycle lifecycle, UseCaseGroup useCaseGroup) {
        this.mUseCaseGroup = useCaseGroup;
        this.mLifecycle = lifecycle;
        lifecycle.addObserver((LifecycleObserver)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public void onStart(LifecycleOwner lifecycleOwner) {
        Object object = this.mUseCaseGroupLock;
        synchronized (object) {
            this.mUseCaseGroup.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void onStop(LifecycleOwner lifecycleOwner) {
        Object object = this.mUseCaseGroupLock;
        synchronized (object) {
            this.mUseCaseGroup.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy(LifecycleOwner lifecycleOwner) {
        Object object = this.mUseCaseGroupLock;
        synchronized (object) {
            this.mUseCaseGroup.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyState() {
        Object object = this.mUseCaseGroupLock;
        synchronized (object) {
            if (this.mLifecycle.getCurrentState().isAtLeast(Lifecycle.State.STARTED)) {
                this.mUseCaseGroup.start();
            }
            for (UseCase useCase : this.mUseCaseGroup.getUseCases()) {
                useCase.notifyState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UseCaseGroup getUseCaseGroup() {
        Object object = this.mUseCaseGroupLock;
        synchronized (object) {
            return this.mUseCaseGroup;
        }
    }

    void release() {
        this.mLifecycle.removeObserver((LifecycleObserver)this);
    }
}

