/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.Rect;
import android.media.Image;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImmutableImageInfo;
import java.nio.ByteBuffer;

final class AndroidImageProxy
implements ImageProxy {
    @GuardedBy(value="this")
    private final Image mImage;
    @GuardedBy(value="this")
    private final PlaneProxy[] mPlanes;
    private final ImageInfo mImageInfo;
    @Nullable
    private Rect mViewPortRect;

    AndroidImageProxy(Image image) {
        this.mImage = image;
        Image.Plane[] originalPlanes = image.getPlanes();
        if (originalPlanes != null) {
            this.mPlanes = new PlaneProxy[originalPlanes.length];
            for (int i = 0; i < originalPlanes.length; ++i) {
                this.mPlanes[i] = new PlaneProxy(originalPlanes[i]);
            }
        } else {
            this.mPlanes = new PlaneProxy[0];
        }
        this.mImageInfo = ImmutableImageInfo.create(null, image.getTimestamp(), 0);
    }

    @Override
    public synchronized void close() {
        this.mImage.close();
    }

    @Override
    @NonNull
    public synchronized Rect getCropRect() {
        return this.mImage.getCropRect();
    }

    @Override
    public synchronized void setCropRect(@Nullable Rect rect) {
        this.mImage.setCropRect(rect);
    }

    @Override
    @NonNull
    public Rect getViewPortRect() {
        return this.mViewPortRect != null ? this.mViewPortRect : this.getCropRect();
    }

    @Override
    public void setViewPortRect(@Nullable Rect viewPortRect) {
        this.mViewPortRect = viewPortRect;
    }

    @Override
    public synchronized int getFormat() {
        return this.mImage.getFormat();
    }

    @Override
    public synchronized int getHeight() {
        return this.mImage.getHeight();
    }

    @Override
    public synchronized int getWidth() {
        return this.mImage.getWidth();
    }

    @Override
    @NonNull
    public synchronized ImageProxy.PlaneProxy[] getPlanes() {
        return this.mPlanes;
    }

    @Override
    @NonNull
    public ImageInfo getImageInfo() {
        return this.mImageInfo;
    }

    @Override
    @ExperimentalGetImage
    public synchronized Image getImage() {
        return this.mImage;
    }

    private static final class PlaneProxy
    implements ImageProxy.PlaneProxy {
        @GuardedBy(value="this")
        private final Image.Plane mPlane;

        PlaneProxy(Image.Plane plane) {
            this.mPlane = plane;
        }

        @Override
        public synchronized int getRowStride() {
            return this.mPlane.getRowStride();
        }

        @Override
        public synchronized int getPixelStride() {
            return this.mPlane.getPixelStride();
        }

        @Override
        @NonNull
        public synchronized ByteBuffer getBuffer() {
            return this.mPlane.getBuffer();
        }
    }
}

