/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.GuardedBy;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.UseCaseMediator;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;

final class UseCaseMediatorLifecycleController
implements LifecycleObserver {
    private final Object mUseCaseMediatorLock = new Object();
    @GuardedBy(value="mUseCaseMediatorLock")
    private final UseCaseMediator mUseCaseMediator;
    private final Lifecycle mLifecycle;

    UseCaseMediatorLifecycleController(Lifecycle lifecycle) {
        this(lifecycle, new UseCaseMediator());
    }

    UseCaseMediatorLifecycleController(Lifecycle lifecycle, UseCaseMediator useCaseMediator) {
        this.mUseCaseMediator = useCaseMediator;
        this.mLifecycle = lifecycle;
        lifecycle.addObserver((LifecycleObserver)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public void onStart(LifecycleOwner lifecycleOwner) {
        Object object = this.mUseCaseMediatorLock;
        synchronized (object) {
            this.mUseCaseMediator.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void onStop(LifecycleOwner lifecycleOwner) {
        Object object = this.mUseCaseMediatorLock;
        synchronized (object) {
            this.mUseCaseMediator.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy(LifecycleOwner lifecycleOwner) {
        Object object = this.mUseCaseMediatorLock;
        synchronized (object) {
            this.mUseCaseMediator.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyState() {
        Object object = this.mUseCaseMediatorLock;
        synchronized (object) {
            if (this.mLifecycle.getCurrentState().isAtLeast(Lifecycle.State.STARTED)) {
                this.mUseCaseMediator.start();
            }
            for (UseCase useCase : this.mUseCaseMediator.getUseCases()) {
                useCase.notifyState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UseCaseMediator getUseCaseMediator() {
        Object object = this.mUseCaseMediatorLock;
        synchronized (object) {
            return this.mUseCaseMediator;
        }
    }

    void release() {
        this.mLifecycle.removeObserver((LifecycleObserver)this);
    }
}

