/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.UseCaseMediatorLifecycleController;
import androidx.camera.core.impl.UseCaseMediator;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class UseCaseMediatorRepository {
    final Object mUseCasesLock = new Object();
    @GuardedBy(value="mUseCasesLock")
    final Map<LifecycleOwner, UseCaseMediatorLifecycleController> mLifecycleToUseCaseMediatorControllerMap = new HashMap<LifecycleOwner, UseCaseMediatorLifecycleController>();
    @GuardedBy(value="mUseCasesLock")
    final List<LifecycleOwner> mActiveLifecycleOwnerList = new ArrayList<LifecycleOwner>();
    @GuardedBy(value="mUseCasesLock")
    LifecycleOwner mCurrentActiveLifecycleOwner = null;

    UseCaseMediatorRepository() {
    }

    UseCaseMediatorLifecycleController getOrCreateUseCaseMediator(LifecycleOwner lifecycleOwner) {
        return this.getOrCreateUseCaseMediator(lifecycleOwner, useCaseMediator -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UseCaseMediatorLifecycleController getOrCreateUseCaseMediator(LifecycleOwner lifecycleOwner, UseCaseMediatorSetup mediatorSetup) {
        UseCaseMediatorLifecycleController useCaseMediatorLifecycleController;
        Object object = this.mUseCasesLock;
        synchronized (object) {
            useCaseMediatorLifecycleController = this.mLifecycleToUseCaseMediatorControllerMap.get(lifecycleOwner);
            if (useCaseMediatorLifecycleController == null) {
                useCaseMediatorLifecycleController = this.createUseCaseMediator(lifecycleOwner);
                mediatorSetup.setup(useCaseMediatorLifecycleController.getUseCaseMediator());
            }
        }
        return useCaseMediatorLifecycleController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UseCaseMediatorLifecycleController createUseCaseMediator(LifecycleOwner lifecycleOwner) {
        if (lifecycleOwner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            throw new IllegalArgumentException("Trying to create use case mediator with destroyed lifecycle.");
        }
        lifecycleOwner.getLifecycle().addObserver(this.createLifecycleObserver());
        UseCaseMediatorLifecycleController useCaseMediatorLifecycleController = new UseCaseMediatorLifecycleController(lifecycleOwner.getLifecycle());
        Object object = this.mUseCasesLock;
        synchronized (object) {
            this.mLifecycleToUseCaseMediatorControllerMap.put(lifecycleOwner, useCaseMediatorLifecycleController);
        }
        return useCaseMediatorLifecycleController;
    }

    private LifecycleObserver createLifecycleObserver() {
        return new LifecycleObserver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
            public void onStart(LifecycleOwner lifecycleOwner) {
                Object object = UseCaseMediatorRepository.this.mUseCasesLock;
                synchronized (object) {
                    for (Map.Entry<LifecycleOwner, UseCaseMediatorLifecycleController> entry : UseCaseMediatorRepository.this.mLifecycleToUseCaseMediatorControllerMap.entrySet()) {
                        UseCaseMediator useCaseMediator;
                        if (entry.getKey() == lifecycleOwner || !(useCaseMediator = entry.getValue().getUseCaseMediator()).isActive()) continue;
                        useCaseMediator.stop();
                    }
                    UseCaseMediatorRepository.this.mCurrentActiveLifecycleOwner = lifecycleOwner;
                    UseCaseMediatorRepository.this.mActiveLifecycleOwnerList.add(0, UseCaseMediatorRepository.this.mCurrentActiveLifecycleOwner);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
            public void onStop(LifecycleOwner lifecycleOwner) {
                Object object = UseCaseMediatorRepository.this.mUseCasesLock;
                synchronized (object) {
                    UseCaseMediatorRepository.this.mActiveLifecycleOwnerList.remove(lifecycleOwner);
                    if (UseCaseMediatorRepository.this.mCurrentActiveLifecycleOwner == lifecycleOwner) {
                        if (UseCaseMediatorRepository.this.mActiveLifecycleOwnerList.size() > 0) {
                            UseCaseMediatorRepository.this.mCurrentActiveLifecycleOwner = UseCaseMediatorRepository.this.mActiveLifecycleOwnerList.get(0);
                            UseCaseMediatorRepository.this.mLifecycleToUseCaseMediatorControllerMap.get(UseCaseMediatorRepository.this.mCurrentActiveLifecycleOwner).getUseCaseMediator().start();
                        } else {
                            UseCaseMediatorRepository.this.mCurrentActiveLifecycleOwner = null;
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
            public void onDestroy(LifecycleOwner lifecycleOwner) {
                Object object = UseCaseMediatorRepository.this.mUseCasesLock;
                synchronized (object) {
                    UseCaseMediatorRepository.this.mLifecycleToUseCaseMediatorControllerMap.remove(lifecycleOwner);
                }
                lifecycleOwner.getLifecycle().removeObserver((LifecycleObserver)this);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<UseCaseMediatorLifecycleController> getUseCaseMediators() {
        Object object = this.mUseCasesLock;
        synchronized (object) {
            return Collections.unmodifiableCollection(this.mLifecycleToUseCaseMediatorControllerMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Map<LifecycleOwner, UseCaseMediatorLifecycleController> getUseCasesMap() {
        Object object = this.mUseCasesLock;
        synchronized (object) {
            return this.mLifecycleToUseCaseMediatorControllerMap;
        }
    }

    public static interface UseCaseMediatorSetup {
        public void setup(@NonNull UseCaseMediator var1);
    }
}

