/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.util.Rational;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ViewPort {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int FILL_START = 0;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int FILL_CENTER = 1;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int FILL_END = 2;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int FIT_START = 3;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int FIT_CENTER = 4;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int FIT_END = 5;
    private int mScaleType;
    @NonNull
    private Rational mAspectRatio;
    private int mRotation;
    private int mLayoutDirection;

    ViewPort(int scaleType, @NonNull Rational aspectRatio, int rotation, int layoutDirection) {
        this.mScaleType = scaleType;
        this.mAspectRatio = aspectRatio;
        this.mRotation = rotation;
        this.mLayoutDirection = layoutDirection;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Rational getAspectRatio() {
        return this.mAspectRatio;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getRotation() {
        return this.mRotation;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getScaleType() {
        return this.mScaleType;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getLayoutDirection() {
        return this.mLayoutDirection;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class Builder {
        private static final int DEFAULT_LAYOUT_DIRECTION = 0;
        private static final int DEFAULT_SCALE_TYPE = 1;
        private int mScaleType = 1;
        private final Rational mAspectRatio;
        private final int mRotation;
        private int mLayoutDirection = 0;

        public Builder(@NonNull Rational aspectRatio, int rotation) {
            this.mAspectRatio = aspectRatio;
            this.mRotation = rotation;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setScaleType(int scaleType) {
            this.mScaleType = scaleType;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setLayoutDirection(int layoutDirection) {
            this.mLayoutDirection = layoutDirection;
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public ViewPort build() {
            Preconditions.checkNotNull((Object)this.mAspectRatio, (Object)"The crop aspect ratio must be set.");
            return new ViewPort(this.mScaleType, this.mAspectRatio, this.mRotation, this.mLayoutDirection);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ScaleType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface LayoutDirection {
    }
}

