/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.camera.core.impl.CameraFilter;
import androidx.camera.core.impl.CameraInternal;
import java.util.LinkedHashSet;
import java.util.Set;

public class LensFacingCameraFilter
implements CameraFilter {
    private int mLensFacing;

    public LensFacingCameraFilter(int lensFacing) {
        this.mLensFacing = lensFacing;
    }

    @Override
    @NonNull
    public Set<CameraInternal> filterCameras(@NonNull Set<CameraInternal> cameras) {
        LinkedHashSet<CameraInternal> resultCameras = new LinkedHashSet<CameraInternal>();
        for (CameraInternal camera : cameras) {
            Integer lensFacing = camera.getCameraInfoInternal().getLensFacing();
            if (lensFacing == null || lensFacing != this.mLensFacing) continue;
            resultCameras.add(camera);
        }
        return resultCameras;
    }

    public int getLensFacing() {
        return this.mLensFacing;
    }
}

