/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.Preview;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageInfoProcessor;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.internal.ThreadConfig;

public final class PreviewConfig
implements UseCaseConfig<Preview>,
ImageOutputConfig,
ThreadConfig {
    public static final Config.Option<ImageInfoProcessor> IMAGE_INFO_PROCESSOR = Config.Option.create("camerax.core.preview.imageInfoProcessor", ImageInfoProcessor.class);
    public static final Config.Option<CaptureProcessor> OPTION_PREVIEW_CAPTURE_PROCESSOR = Config.Option.create("camerax.core.preview.captureProcessor", CaptureProcessor.class);
    private final OptionsBundle mConfig;

    public PreviewConfig(@NonNull OptionsBundle config) {
        this.mConfig = config;
    }

    @Override
    @NonNull
    public Config getConfig() {
        return this.mConfig;
    }

    @Nullable
    public ImageInfoProcessor getImageInfoProcessor(@Nullable ImageInfoProcessor valueIfMissing) {
        return this.retrieveOption(IMAGE_INFO_PROCESSOR, valueIfMissing);
    }

    @NonNull
    ImageInfoProcessor getImageInfoProcessor() {
        return this.retrieveOption(IMAGE_INFO_PROCESSOR);
    }

    @Nullable
    public CaptureProcessor getCaptureProcessor(@Nullable CaptureProcessor valueIfMissing) {
        return this.retrieveOption(OPTION_PREVIEW_CAPTURE_PROCESSOR, valueIfMissing);
    }

    @NonNull
    public CaptureProcessor getCaptureProcessor() {
        return this.retrieveOption(OPTION_PREVIEW_CAPTURE_PROCESSOR);
    }

    @Override
    public int getInputFormat() {
        return (Integer)this.retrieveOption(OPTION_INPUT_FORMAT);
    }
}

