/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.SessionConfig;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class UseCaseAttachState {
    private static final String TAG = "UseCaseAttachState";
    private final String mCameraId;
    private final Map<UseCase, UseCaseAttachInfo> mAttachedUseCasesToInfoMap = new HashMap<UseCase, UseCaseAttachInfo>();

    public UseCaseAttachState(@NonNull String cameraId) {
        this.mCameraId = cameraId;
    }

    public void setUseCaseActive(@NonNull UseCase useCase) {
        UseCaseAttachInfo useCaseAttachInfo = this.getOrCreateUseCaseAttachInfo(useCase);
        useCaseAttachInfo.setActive(true);
    }

    public void setUseCaseInactive(@NonNull UseCase useCase) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCase)) {
            return;
        }
        UseCaseAttachInfo useCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCase);
        useCaseAttachInfo.setActive(false);
        if (!useCaseAttachInfo.getAttached()) {
            this.mAttachedUseCasesToInfoMap.remove(useCase);
        }
    }

    public void setUseCaseAttached(@NonNull UseCase useCase) {
        UseCaseAttachInfo useCaseAttachInfo = this.getOrCreateUseCaseAttachInfo(useCase);
        useCaseAttachInfo.setAttached(true);
    }

    public void setUseCaseDetached(@NonNull UseCase useCase) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCase)) {
            return;
        }
        UseCaseAttachInfo useCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCase);
        useCaseAttachInfo.setAttached(false);
        if (!useCaseAttachInfo.getActive()) {
            this.mAttachedUseCasesToInfoMap.remove(useCase);
        }
    }

    public boolean isUseCaseAttached(@NonNull UseCase useCase) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCase)) {
            return false;
        }
        UseCaseAttachInfo useCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCase);
        return useCaseAttachInfo.getAttached();
    }

    @NonNull
    public Collection<UseCase> getAttachedUseCases() {
        return Collections.unmodifiableCollection(this.getUseCases(new AttachStateFilter(){

            @Override
            public boolean filter(UseCaseAttachInfo useCaseAttachInfo) {
                return useCaseAttachInfo.getAttached();
            }
        }));
    }

    @NonNull
    public Collection<UseCase> getActiveAndAttachedUseCases() {
        return Collections.unmodifiableCollection(this.getUseCases(new AttachStateFilter(){

            @Override
            public boolean filter(UseCaseAttachInfo useCaseAttachInfo) {
                return useCaseAttachInfo.getActive() && useCaseAttachInfo.getAttached();
            }
        }));
    }

    public void updateUseCase(@NonNull UseCase useCase) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCase)) {
            return;
        }
        UseCaseAttachInfo newUseCaseAttachInfo = new UseCaseAttachInfo(useCase.getSessionConfig());
        UseCaseAttachInfo oldUseCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCase);
        newUseCaseAttachInfo.setAttached(oldUseCaseAttachInfo.getAttached());
        newUseCaseAttachInfo.setActive(oldUseCaseAttachInfo.getActive());
        this.mAttachedUseCasesToInfoMap.put(useCase, newUseCaseAttachInfo);
    }

    @NonNull
    public SessionConfig.ValidatingBuilder getActiveAndAttachedBuilder() {
        SessionConfig.ValidatingBuilder validatingBuilder = new SessionConfig.ValidatingBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<UseCase, UseCaseAttachInfo> attachedUseCase : this.mAttachedUseCasesToInfoMap.entrySet()) {
            UseCaseAttachInfo useCaseAttachInfo = attachedUseCase.getValue();
            if (!useCaseAttachInfo.getActive() || !useCaseAttachInfo.getAttached()) continue;
            UseCase useCase = attachedUseCase.getKey();
            validatingBuilder.add(useCaseAttachInfo.getSessionConfig());
            list.add(useCase.getName());
        }
        Log.d((String)TAG, (String)("Active and attached use case: " + list + " for camera: " + this.mCameraId));
        return validatingBuilder;
    }

    @NonNull
    public SessionConfig.ValidatingBuilder getAttachedBuilder() {
        SessionConfig.ValidatingBuilder validatingBuilder = new SessionConfig.ValidatingBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<UseCase, UseCaseAttachInfo> attachedUseCase : this.mAttachedUseCasesToInfoMap.entrySet()) {
            UseCaseAttachInfo useCaseAttachInfo = attachedUseCase.getValue();
            if (!useCaseAttachInfo.getAttached()) continue;
            validatingBuilder.add(useCaseAttachInfo.getSessionConfig());
            UseCase useCase = attachedUseCase.getKey();
            list.add(useCase.getName());
        }
        Log.d((String)TAG, (String)("All use case: " + list + " for camera: " + this.mCameraId));
        return validatingBuilder;
    }

    @NonNull
    public SessionConfig getUseCaseSessionConfig(@NonNull UseCase useCase) {
        if (!this.mAttachedUseCasesToInfoMap.containsKey(useCase)) {
            return SessionConfig.defaultEmptySessionConfig();
        }
        UseCaseAttachInfo attachInfo = this.mAttachedUseCasesToInfoMap.get(useCase);
        return attachInfo.getSessionConfig();
    }

    private UseCaseAttachInfo getOrCreateUseCaseAttachInfo(UseCase useCase) {
        Preconditions.checkArgument((boolean)useCase.getCamera().getCameraInfoInternal().getCameraId().equals(this.mCameraId));
        UseCaseAttachInfo useCaseAttachInfo = this.mAttachedUseCasesToInfoMap.get(useCase);
        if (useCaseAttachInfo == null) {
            useCaseAttachInfo = new UseCaseAttachInfo(useCase.getSessionConfig());
            this.mAttachedUseCasesToInfoMap.put(useCase, useCaseAttachInfo);
        }
        return useCaseAttachInfo;
    }

    private Collection<UseCase> getUseCases(AttachStateFilter attachStateFilter) {
        ArrayList<UseCase> useCases = new ArrayList<UseCase>();
        for (Map.Entry<UseCase, UseCaseAttachInfo> attachedUseCase : this.mAttachedUseCasesToInfoMap.entrySet()) {
            if (attachStateFilter != null && !attachStateFilter.filter(attachedUseCase.getValue())) continue;
            useCases.add(attachedUseCase.getKey());
        }
        return useCases;
    }

    private static final class UseCaseAttachInfo {
        @NonNull
        private final SessionConfig mSessionConfig;
        private boolean mAttached = false;
        private boolean mActive = false;

        UseCaseAttachInfo(@NonNull SessionConfig sessionConfig) {
            this.mSessionConfig = sessionConfig;
        }

        @NonNull
        SessionConfig getSessionConfig() {
            return this.mSessionConfig;
        }

        boolean getAttached() {
            return this.mAttached;
        }

        void setAttached(boolean attached) {
            this.mAttached = attached;
        }

        boolean getActive() {
            return this.mActive;
        }

        void setActive(boolean active) {
            this.mActive = active;
        }
    }

    private static interface AttachStateFilter {
        public boolean filter(UseCaseAttachInfo var1);
    }
}

