/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import android.util.Log;

public final class CameraOrientationUtil {
    private static final String TAG = "CameraOrientationUtil";
    private static final boolean DEBUG = Log.isLoggable((String)"CameraOrientationUtil", (int)3);

    private CameraOrientationUtil() {
    }

    public static int getRelativeImageRotation(int destRotationDegrees, int sourceRotationDegrees, boolean isOppositeFacing) {
        int result = isOppositeFacing ? (sourceRotationDegrees - destRotationDegrees + 360) % 360 : (sourceRotationDegrees + destRotationDegrees) % 360;
        if (DEBUG) {
            Log.d((String)TAG, (String)String.format("getRelativeImageRotation: destRotationDegrees=%s, sourceRotationDegrees=%s, isOppositeFacing=%s, result=%s", destRotationDegrees, sourceRotationDegrees, isOppositeFacing, result));
        }
        return result;
    }

    public static int surfaceRotationToDegrees(int rotationEnum) {
        int rotationDegrees;
        switch (rotationEnum) {
            case 0: {
                rotationDegrees = 0;
                break;
            }
            case 1: {
                rotationDegrees = 90;
                break;
            }
            case 2: {
                rotationDegrees = 180;
                break;
            }
            case 3: {
                rotationDegrees = 270;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported surface rotation: " + rotationEnum);
            }
        }
        return rotationDegrees;
    }

    public static int degreesToSurfaceRotation(int degrees) {
        int surfaceRotation = 0;
        switch (degrees) {
            case 0: {
                surfaceRotation = 0;
                break;
            }
            case 90: {
                surfaceRotation = 1;
                break;
            }
            case 180: {
                surfaceRotation = 2;
                break;
            }
            case 270: {
                surfaceRotation = 3;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid sensor rotation: " + degrees);
            }
        }
        return surfaceRotation;
    }
}

