/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils.executor;

import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.core.util.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

final class SequentialExecutor
implements Executor {
    private static final String TAG = "SequentialExecutor";
    @GuardedBy(value="mQueue")
    final Deque<Runnable> mQueue = new ArrayDeque<Runnable>();
    private final Executor mExecutor;
    private final QueueWorker mWorker = new QueueWorker();
    @GuardedBy(value="mQueue")
    WorkerRunningState mWorkerRunningState = WorkerRunningState.IDLE;
    @GuardedBy(value="mQueue")
    long mWorkerRunCount = 0L;

    SequentialExecutor(Executor executor) {
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final Runnable task) {
        boolean alreadyMarkedQueued;
        Runnable submittedTask;
        long oldRunCount;
        Preconditions.checkNotNull((Object)task);
        Deque<Runnable> deque = this.mQueue;
        synchronized (deque) {
            if (this.mWorkerRunningState == WorkerRunningState.RUNNING || this.mWorkerRunningState == WorkerRunningState.QUEUED) {
                this.mQueue.add(task);
                return;
            }
            oldRunCount = this.mWorkerRunCount;
            submittedTask = new Runnable(){

                @Override
                public void run() {
                    task.run();
                }
            };
            this.mQueue.add(submittedTask);
            this.mWorkerRunningState = WorkerRunningState.QUEUING;
        }
        try {
            this.mExecutor.execute(this.mWorker);
        }
        catch (Error | RuntimeException t) {
            Deque<Runnable> deque2 = this.mQueue;
            synchronized (deque2) {
                boolean removed;
                boolean bl = removed = (this.mWorkerRunningState == WorkerRunningState.IDLE || this.mWorkerRunningState == WorkerRunningState.QUEUING) && this.mQueue.removeLastOccurrence(submittedTask);
                if (!(t instanceof RejectedExecutionException) || removed) {
                    throw t;
                }
            }
            return;
        }
        boolean bl = alreadyMarkedQueued = this.mWorkerRunningState != WorkerRunningState.QUEUING;
        if (alreadyMarkedQueued) {
            return;
        }
        Deque<Runnable> deque3 = this.mQueue;
        synchronized (deque3) {
            if (this.mWorkerRunCount == oldRunCount && this.mWorkerRunningState == WorkerRunningState.QUEUING) {
                this.mWorkerRunningState = WorkerRunningState.QUEUED;
            }
        }
    }

    final class QueueWorker
    implements Runnable {
        QueueWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.workOnQueue();
            }
            catch (Error e) {
                Deque<Runnable> deque = SequentialExecutor.this.mQueue;
                synchronized (deque) {
                    SequentialExecutor.this.mWorkerRunningState = WorkerRunningState.IDLE;
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void workOnQueue() {
            Runnable task;
            boolean interruptedDuringTask = false;
            boolean hasSetRunning = false;
            while (true) {
                Deque<Runnable> deque = SequentialExecutor.this.mQueue;
                // MONITORENTER : deque
                if (!hasSetRunning) {
                    if (SequentialExecutor.this.mWorkerRunningState == WorkerRunningState.RUNNING) {
                        // MONITOREXIT : deque
                        if (!interruptedDuringTask) return;
                        Thread.currentThread().interrupt();
                        return;
                    }
                    ++SequentialExecutor.this.mWorkerRunCount;
                    SequentialExecutor.this.mWorkerRunningState = WorkerRunningState.RUNNING;
                    hasSetRunning = true;
                }
                if ((task = SequentialExecutor.this.mQueue.poll()) != null) break block12;
                SequentialExecutor.this.mWorkerRunningState = WorkerRunningState.IDLE;
                break;
            }
            catch (Throwable throwable) {
                if (!interruptedDuringTask) throw throwable;
                Thread.currentThread().interrupt();
                throw throwable;
            }
            {
                block12: {
                    // MONITOREXIT : deque
                    if (!interruptedDuringTask) return;
                    Thread.currentThread().interrupt();
                    return;
                }
                // MONITOREXIT : deque
                interruptedDuringTask |= Thread.interrupted();
                try {
                    task.run();
                }
                catch (RuntimeException e) {
                    Log.e((String)SequentialExecutor.TAG, (String)("Exception while executing runnable " + task), (Throwable)e);
                }
                continue;
            }
        }
    }

    static enum WorkerRunningState {
        IDLE,
        QUEUING,
        QUEUED,
        RUNNING;

    }
}

