/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.camera.core.CameraUnavailableException;
import androidx.camera.core.InitializationException;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraFactory;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class CameraRepository {
    private static final String TAG = "CameraRepository";
    private final Object mCamerasLock = new Object();
    @GuardedBy(value="mCamerasLock")
    private final Map<String, CameraInternal> mCameras = new LinkedHashMap<String, CameraInternal>();
    @GuardedBy(value="mCamerasLock")
    private final Set<CameraInternal> mReleasingCameras = new HashSet<CameraInternal>();
    @GuardedBy(value="mCamerasLock")
    private ListenableFuture<Void> mDeinitFuture;
    @GuardedBy(value="mCamerasLock")
    private CallbackToFutureAdapter.Completer<Void> mDeinitCompleter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(@NonNull CameraFactory cameraFactory) throws InitializationException {
        Object object = this.mCamerasLock;
        synchronized (object) {
            try {
                Set<String> camerasList = cameraFactory.getAvailableCameraIds();
                for (String id : camerasList) {
                    Logger.d(TAG, "Added camera: " + id);
                    this.mCameras.put(id, cameraFactory.getCamera(id));
                }
            }
            catch (CameraUnavailableException e) {
                throw new InitializationException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ListenableFuture<Void> deinit() {
        Object object = this.mCamerasLock;
        synchronized (object) {
            if (this.mCameras.isEmpty()) {
                return this.mDeinitFuture == null ? Futures.immediateFuture(null) : this.mDeinitFuture;
            }
            ListenableFuture currentFuture = this.mDeinitFuture;
            if (currentFuture == null) {
                this.mDeinitFuture = currentFuture = CallbackToFutureAdapter.getFuture(completer -> {
                    Object object = this.mCamerasLock;
                    synchronized (object) {
                        this.mDeinitCompleter = completer;
                    }
                    return "CameraRepository-deinit";
                });
            }
            this.mReleasingCameras.addAll(this.mCameras.values());
            for (CameraInternal cameraInternal : this.mCameras.values()) {
                cameraInternal.release().addListener(() -> {
                    Object object = this.mCamerasLock;
                    synchronized (object) {
                        this.mReleasingCameras.remove(cameraInternal);
                        if (this.mReleasingCameras.isEmpty()) {
                            Preconditions.checkNotNull(this.mDeinitCompleter);
                            this.mDeinitCompleter.set(null);
                            this.mDeinitCompleter = null;
                            this.mDeinitFuture = null;
                        }
                    }
                }, CameraXExecutors.directExecutor());
            }
            this.mCameras.clear();
            return currentFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public CameraInternal getCamera(@NonNull String cameraId) {
        Object object = this.mCamerasLock;
        synchronized (object) {
            CameraInternal cameraInternal = this.mCameras.get(cameraId);
            if (cameraInternal == null) {
                throw new IllegalArgumentException("Invalid camera: " + cameraId);
            }
            return cameraInternal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public LinkedHashSet<CameraInternal> getCameras() {
        Object object = this.mCamerasLock;
        synchronized (object) {
            return new LinkedHashSet<CameraInternal>(this.mCameras.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    Set<String> getCameraIds() {
        Object object = this.mCamerasLock;
        synchronized (object) {
            return new LinkedHashSet<String>(this.mCameras.keySet());
        }
    }
}

