/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.experimental.UseExperimental;
import androidx.camera.core.CameraExecutor;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraXConfig;
import androidx.camera.core.ExperimentalAvailableCamerasLimiter;
import androidx.camera.core.InitializationException;
import androidx.camera.core.Logger;
import androidx.camera.core.R;
import androidx.camera.core.impl.CameraDeviceSurfaceManager;
import androidx.camera.core.impl.CameraFactory;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CameraRepository;
import androidx.camera.core.impl.CameraThreadConfig;
import androidx.camera.core.impl.CameraValidator;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.compat.quirk.DeviceQuirks;
import androidx.camera.core.internal.compat.quirk.IncompleteCameraListQuirk;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.os.HandlerCompat;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@MainThread
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CameraX {
    private static final String TAG = "CameraX";
    private static final String RETRY_TOKEN = "retry_token";
    private static final long WAIT_INITIALIZED_TIMEOUT_MILLIS = 3000L;
    private static final long RETRY_SLEEP_MILLIS = 500L;
    static final Object INSTANCE_LOCK = new Object();
    @GuardedBy(value="INSTANCE_LOCK")
    static CameraX sInstance = null;
    @GuardedBy(value="INSTANCE_LOCK")
    private static CameraXConfig.Provider sConfigProvider = null;
    @GuardedBy(value="INSTANCE_LOCK")
    private static ListenableFuture<Void> sInitializeFuture = Futures.immediateFailedFuture(new IllegalStateException("CameraX is not initialized."));
    @GuardedBy(value="INSTANCE_LOCK")
    private static ListenableFuture<Void> sShutdownFuture = Futures.immediateFuture(null);
    final CameraRepository mCameraRepository = new CameraRepository();
    private final Object mInitializeLock = new Object();
    private final CameraXConfig mCameraXConfig;
    private final Executor mCameraExecutor;
    private final Handler mSchedulerHandler;
    @Nullable
    private final HandlerThread mSchedulerThread;
    private CameraFactory mCameraFactory;
    private CameraDeviceSurfaceManager mSurfaceManager;
    private UseCaseConfigFactory mDefaultConfigFactory;
    private Context mAppContext;
    @GuardedBy(value="mInitializeLock")
    private InternalInitState mInitState = InternalInitState.UNINITIALIZED;
    @GuardedBy(value="mInitializeLock")
    private ListenableFuture<Void> mShutdownInternalFuture = Futures.immediateFuture(null);

    CameraX(@NonNull CameraXConfig cameraXConfig) {
        this.mCameraXConfig = (CameraXConfig)Preconditions.checkNotNull((Object)cameraXConfig);
        Executor executor = cameraXConfig.getCameraExecutor(null);
        Handler schedulerHandler = cameraXConfig.getSchedulerHandler(null);
        Executor executor2 = this.mCameraExecutor = executor == null ? new CameraExecutor() : executor;
        if (schedulerHandler == null) {
            this.mSchedulerThread = new HandlerThread("CameraX-scheduler", 10);
            this.mSchedulerThread.start();
            this.mSchedulerHandler = HandlerCompat.createAsync((Looper)this.mSchedulerThread.getLooper());
        } else {
            this.mSchedulerThread = null;
            this.mSchedulerHandler = schedulerHandler;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static CameraInternal getCameraWithCameraSelector(@NonNull CameraSelector cameraSelector) {
        CameraX cameraX = CameraX.checkInitialized();
        return cameraSelector.select(cameraX.getCameraRepository().getCameras());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    @NonNull
    public static ListenableFuture<Void> initialize(@NonNull Context context, @NonNull CameraXConfig cameraXConfig) {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            Preconditions.checkNotNull((Object)context);
            CameraX.configureInstanceLocked(() -> cameraXConfig);
            CameraX.initializeInstanceLocked(context);
            return sInitializeFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureInstance(@NonNull CameraXConfig cameraXConfig) {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            CameraX.configureInstanceLocked(() -> cameraXConfig);
        }
    }

    @GuardedBy(value="INSTANCE_LOCK")
    private static void configureInstanceLocked(@NonNull CameraXConfig.Provider configProvider) {
        Preconditions.checkNotNull((Object)configProvider);
        Preconditions.checkState((sConfigProvider == null ? 1 : 0) != 0, (String)"CameraX has already been configured. To use a different configuration, shutdown() must be called.");
        sConfigProvider = configProvider;
        Integer minLogLevel = configProvider.getCameraXConfig().retrieveOption(CameraXConfig.OPTION_MIN_LOGGING_LEVEL, null);
        if (minLogLevel != null) {
            Logger.setMinLogLevel(minLogLevel);
        }
    }

    @GuardedBy(value="INSTANCE_LOCK")
    private static void initializeInstanceLocked(@NonNull Context context) {
        CameraX cameraX;
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkState((sInstance == null ? 1 : 0) != 0, (String)"CameraX already initialized.");
        Preconditions.checkNotNull((Object)sConfigProvider);
        sInstance = cameraX = new CameraX(sConfigProvider.getCameraXConfig());
        sInitializeFuture = CallbackToFutureAdapter.getFuture(completer -> {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                FutureChain future = FutureChain.from(sShutdownFuture).transformAsync(input -> cameraX.initInternal(context), CameraXExecutors.directExecutor());
                Futures.addCallback(future, new FutureCallback<Void>(){

                    @Override
                    public void onSuccess(@Nullable Void result) {
                        completer.set(null);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onFailure(Throwable t) {
                        Logger.w(CameraX.TAG, "CameraX initialize() failed", t);
                        Object object = INSTANCE_LOCK;
                        synchronized (object) {
                            if (sInstance == cameraX) {
                                CameraX.shutdownLocked();
                            }
                        }
                        completer.setException(t);
                    }
                }, CameraXExecutors.directExecutor());
                return "CameraX-initialize";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ListenableFuture<Void> shutdown() {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            sConfigProvider = null;
            Logger.resetMinLogLevel();
            return CameraX.shutdownLocked();
        }
    }

    @GuardedBy(value="INSTANCE_LOCK")
    @NonNull
    static ListenableFuture<Void> shutdownLocked() {
        if (sInstance == null) {
            return sShutdownFuture;
        }
        CameraX cameraX = sInstance;
        sInstance = null;
        sShutdownFuture = CallbackToFutureAdapter.getFuture(completer -> {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                sInitializeFuture.addListener(() -> Futures.propagate(cameraX.shutdownInternal(), completer), CameraXExecutors.directExecutor());
                return "CameraX shutdown";
            }
        });
        return sShutdownFuture;
    }

    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static Context getContext() {
        CameraX cameraX = CameraX.checkInitialized();
        return cameraX.mAppContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    public static boolean isInitialized() {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            return sInstance != null && sInstance.isInitializedInternal();
        }
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public CameraFactory getCameraFactory() {
        if (this.mCameraFactory == null) {
            throw new IllegalStateException("CameraX not initialized yet.");
        }
        return this.mCameraFactory;
    }

    @NonNull
    private static CameraX checkInitialized() {
        CameraX cameraX = CameraX.waitInitialized();
        Preconditions.checkState((boolean)cameraX.isInitializedInternal(), (String)"Must call CameraX.initialize() first");
        return cameraX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static ListenableFuture<CameraX> getOrCreateInstance(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context, (Object)"Context must not be null.");
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            boolean isConfigured = sConfigProvider != null;
            ListenableFuture<CameraX> instanceFuture = CameraX.getInstanceLocked();
            if (instanceFuture.isDone()) {
                try {
                    instanceFuture.get();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Unexpected thread interrupt. Should not be possible since future is already complete.", e);
                }
                catch (ExecutionException e) {
                    CameraX.shutdownLocked();
                    instanceFuture = null;
                }
            }
            if (instanceFuture == null) {
                if (!isConfigured) {
                    CameraXConfig.Provider configProvider = CameraX.getConfigProvider(context);
                    if (configProvider == null) {
                        throw new IllegalStateException("CameraX is not configured properly. The most likely cause is you did not include a default implementation in your build such as 'camera-camera2'.");
                    }
                    CameraX.configureInstanceLocked(configProvider);
                }
                CameraX.initializeInstanceLocked(context);
                instanceFuture = CameraX.getInstanceLocked();
            }
            return instanceFuture;
        }
    }

    @Nullable
    private static CameraXConfig.Provider getConfigProvider(@NonNull Context context) {
        CameraXConfig.Provider configProvider = null;
        Application application = CameraX.getApplicationFromContext(context);
        if (application instanceof CameraXConfig.Provider) {
            configProvider = (CameraXConfig.Provider)application;
        } else {
            try {
                Resources resources = context.getApplicationContext().getResources();
                String defaultProviderClassName = resources.getString(R.string.androidx_camera_default_config_provider);
                Class<?> providerClass = Class.forName(defaultProviderClassName);
                configProvider = (CameraXConfig.Provider)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Resources.NotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
                Logger.e(TAG, "Failed to retrieve default CameraXConfig.Provider from resources", e);
            }
        }
        return configProvider;
    }

    @Nullable
    private static Application getApplicationFromContext(@NonNull Context context) {
        Application application = null;
        Context appContext = context.getApplicationContext();
        while (appContext instanceof ContextWrapper) {
            if (appContext instanceof Application) {
                application = (Application)appContext;
                break;
            }
            appContext = ((ContextWrapper)appContext).getBaseContext();
        }
        return application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ListenableFuture<CameraX> getInstance() {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            return CameraX.getInstanceLocked();
        }
    }

    @GuardedBy(value="INSTANCE_LOCK")
    @NonNull
    private static ListenableFuture<CameraX> getInstanceLocked() {
        CameraX cameraX = sInstance;
        if (cameraX == null) {
            return Futures.immediateFailedFuture(new IllegalStateException("Must call CameraX.initialize() first"));
        }
        return Futures.transform(sInitializeFuture, nullVoid -> cameraX, CameraXExecutors.directExecutor());
    }

    @NonNull
    private static CameraX waitInitialized() {
        ListenableFuture<CameraX> future = CameraX.getInstance();
        try {
            return (CameraX)future.get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public CameraDeviceSurfaceManager getCameraDeviceSurfaceManager() {
        if (this.mSurfaceManager == null) {
            throw new IllegalStateException("CameraX not initialized yet.");
        }
        return this.mSurfaceManager;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public CameraRepository getCameraRepository() {
        return this.mCameraRepository;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public UseCaseConfigFactory getDefaultConfigFactory() {
        if (this.mDefaultConfigFactory == null) {
            throw new IllegalStateException("CameraX not initialized yet.");
        }
        return this.mDefaultConfigFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<Void> initInternal(@NonNull Context context) {
        Object object = this.mInitializeLock;
        synchronized (object) {
            Preconditions.checkState((this.mInitState == InternalInitState.UNINITIALIZED ? 1 : 0) != 0, (String)"CameraX.initInternal() should only be called once per instance");
            this.mInitState = InternalInitState.INITIALIZING;
            return CallbackToFutureAdapter.getFuture(completer -> {
                this.initAndRetryRecursively(this.mCameraExecutor, SystemClock.elapsedRealtime(), context, (CallbackToFutureAdapter.Completer<Void>)completer);
                return "CameraX initInternal";
            });
        }
    }

    @UseExperimental(markerClass=ExperimentalAvailableCamerasLimiter.class)
    private void initAndRetryRecursively(@NonNull Executor cameraExecutor, long startMs, @NonNull Context context, @NonNull CallbackToFutureAdapter.Completer<Void> completer) {
        cameraExecutor.execute(() -> {
            try {
                CameraFactory.Provider cameraFactoryProvider;
                this.mAppContext = CameraX.getApplicationFromContext(context);
                if (this.mAppContext == null) {
                    this.mAppContext = context.getApplicationContext();
                }
                if ((cameraFactoryProvider = this.mCameraXConfig.getCameraFactoryProvider(null)) == null) {
                    throw new InitializationException(new IllegalArgumentException("Invalid app configuration provided. Missing CameraFactory."));
                }
                CameraThreadConfig cameraThreadConfig = CameraThreadConfig.create(this.mCameraExecutor, this.mSchedulerHandler);
                CameraSelector availableCamerasLimiter = this.mCameraXConfig.getAvailableCamerasLimiter(null);
                this.mCameraFactory = cameraFactoryProvider.newInstance(this.mAppContext, cameraThreadConfig, availableCamerasLimiter);
                CameraDeviceSurfaceManager.Provider surfaceManagerProvider = this.mCameraXConfig.getDeviceSurfaceManagerProvider(null);
                if (surfaceManagerProvider == null) {
                    throw new InitializationException(new IllegalArgumentException("Invalid app configuration provided. Missing CameraDeviceSurfaceManager."));
                }
                this.mSurfaceManager = surfaceManagerProvider.newInstance(this.mAppContext, this.mCameraFactory.getCameraManager(), this.mCameraFactory.getAvailableCameraIds());
                UseCaseConfigFactory.Provider configFactoryProvider = this.mCameraXConfig.getUseCaseConfigFactoryProvider(null);
                if (configFactoryProvider == null) {
                    throw new InitializationException(new IllegalArgumentException("Invalid app configuration provided. Missing UseCaseConfigFactory."));
                }
                this.mDefaultConfigFactory = configFactoryProvider.newInstance(this.mAppContext);
                if (cameraExecutor instanceof CameraExecutor) {
                    CameraExecutor executor = (CameraExecutor)cameraExecutor;
                    executor.init(this.mCameraFactory);
                }
                this.mCameraRepository.init(this.mCameraFactory);
                if (DeviceQuirks.get(IncompleteCameraListQuirk.class) != null) {
                    CameraValidator.validateCameras(this.mAppContext, this.mCameraRepository);
                }
                this.setStateToInitialized();
                completer.set(null);
            }
            catch (InitializationException | CameraValidator.CameraIdListIncorrectException | RuntimeException e) {
                if (SystemClock.elapsedRealtime() - startMs < 2500L) {
                    Logger.w(TAG, "Retry init. Start time " + startMs + " current time " + SystemClock.elapsedRealtime(), e);
                    HandlerCompat.postDelayed((Handler)this.mSchedulerHandler, () -> this.initAndRetryRecursively(cameraExecutor, startMs, this.mAppContext, completer), (Object)RETRY_TOKEN, (long)500L);
                }
                this.setStateToInitialized();
                if (e instanceof CameraValidator.CameraIdListIncorrectException) {
                    Logger.e(TAG, "The device might underreport the amount of the cameras. Finish the initialize task since we are already reaching the maximum number of retries.");
                    completer.set(null);
                }
                if (e instanceof InitializationException) {
                    completer.setException((Throwable)e);
                }
                completer.setException((Throwable)new InitializationException(e));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStateToInitialized() {
        Object object = this.mInitializeLock;
        synchronized (object) {
            this.mInitState = InternalInitState.INITIALIZED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private ListenableFuture<Void> shutdownInternal() {
        Object object = this.mInitializeLock;
        synchronized (object) {
            this.mSchedulerHandler.removeCallbacksAndMessages((Object)RETRY_TOKEN);
            switch (this.mInitState) {
                case UNINITIALIZED: {
                    this.mInitState = InternalInitState.SHUTDOWN;
                    return Futures.immediateFuture(null);
                }
                case INITIALIZING: {
                    throw new IllegalStateException("CameraX could not be shutdown when it is initializing.");
                }
                case INITIALIZED: {
                    this.mInitState = InternalInitState.SHUTDOWN;
                    this.mShutdownInternalFuture = CallbackToFutureAdapter.getFuture(completer -> {
                        ListenableFuture<Void> future = this.mCameraRepository.deinit();
                        future.addListener(() -> {
                            if (this.mSchedulerThread != null) {
                                if (this.mCameraExecutor instanceof CameraExecutor) {
                                    CameraExecutor executor = (CameraExecutor)this.mCameraExecutor;
                                    executor.deinit();
                                }
                                this.mSchedulerThread.quit();
                                completer.set(null);
                            }
                        }, this.mCameraExecutor);
                        return "CameraX shutdownInternal";
                    });
                }
            }
            return this.mShutdownInternalFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInitializedInternal() {
        Object object = this.mInitializeLock;
        synchronized (object) {
            return this.mInitState == InternalInitState.INITIALIZED;
        }
    }

    private static enum InternalInitState {
        UNINITIALIZED,
        INITIALIZING,
        INITIALIZED,
        SHUTDOWN;

    }
}

