/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import androidx.camera.core.ImageAnalysisAbstractAnalyzer;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;

final class ImageAnalysisBlockingAnalyzer
extends ImageAnalysisAbstractAnalyzer {
    ImageAnalysisBlockingAnalyzer() {
    }

    @Override
    public void onImageAvailable(@NonNull ImageReaderProxy imageReaderProxy) {
        final ImageProxy image = imageReaderProxy.acquireNextImage();
        if (image == null) {
            return;
        }
        ListenableFuture<Void> analyzeFuture = this.analyzeImage(image);
        Futures.addCallback(analyzeFuture, new FutureCallback<Void>(){

            @Override
            public void onSuccess(Void result) {
            }

            @Override
            public void onFailure(Throwable t) {
                image.close();
            }
        }, CameraXExecutors.directExecutor());
    }
}

