/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.core.internal.compat.quirk.DeviceQuirks;
import androidx.camera.core.internal.compat.quirk.HuaweiMediaStoreLocationValidationQuirk;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class ImageSaveLocationValidator {
    private static final String TAG = "SaveLocationValidator";

    private ImageSaveLocationValidator() {
    }

    static boolean isValid(@NonNull ImageCapture.OutputFileOptions outputFileOptions) {
        if (ImageSaveLocationValidator.isSaveToFile(outputFileOptions)) {
            return ImageSaveLocationValidator.canSaveToFile(outputFileOptions.getFile());
        }
        if (ImageSaveLocationValidator.isSaveToMediaStore(outputFileOptions)) {
            HuaweiMediaStoreLocationValidationQuirk huaweiQuirk = DeviceQuirks.get(HuaweiMediaStoreLocationValidationQuirk.class);
            if (huaweiQuirk != null) {
                return huaweiQuirk.canSaveToMediaStore();
            }
            return ImageSaveLocationValidator.canSaveToMediaStore(outputFileOptions.getContentResolver(), outputFileOptions.getSaveCollection(), outputFileOptions.getContentValues());
        }
        return true;
    }

    private static boolean isSaveToFile(@NonNull ImageCapture.OutputFileOptions outputFileOptions) {
        return outputFileOptions.getFile() != null;
    }

    private static boolean isSaveToMediaStore(@NonNull ImageCapture.OutputFileOptions outputFileOptions) {
        return outputFileOptions.getSaveCollection() != null && outputFileOptions.getContentResolver() != null && outputFileOptions.getContentValues() != null;
    }

    private static boolean canSaveToFile(@NonNull File file) {
        boolean bl;
        FileOutputStream ignored = new FileOutputStream(file);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                Logger.e(TAG, "Failed to open a write stream to " + file.toString(), exception);
                return false;
            }
        }
        ignored.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canSaveToMediaStore(@NonNull ContentResolver contentResolver, @NonNull Uri uri, @NonNull ContentValues values) {
        Uri outputUri;
        try {
            outputUri = contentResolver.insert(uri, values);
        }
        catch (IllegalArgumentException exception) {
            Logger.e(TAG, "Failed to insert into " + uri.toString(), exception);
            return false;
        }
        if (outputUri == null) {
            return false;
        }
        try {
            boolean bl;
            block20: {
                OutputStream stream = contentResolver.openOutputStream(outputUri);
                try {
                    boolean bl2 = bl = stream != null;
                    if (stream == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable exception) {
                                throwable.addSuppressed(exception);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException exception) {
                        Logger.e(TAG, "Failed to open a write stream to" + outputUri.toString(), exception);
                        boolean bl3 = false;
                        return bl3;
                    }
                }
                stream.close();
            }
            return bl;
        }
        finally {
            try {
                contentResolver.delete(outputUri, null, null);
            }
            catch (IllegalArgumentException exception) {
                Logger.e(TAG, "Failed to delete inserted row at " + outputUri.toString(), exception);
            }
        }
    }
}

