/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.content.ContentValues;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.utils.Exif;
import androidx.camera.core.internal.compat.workaround.ExifRotationAvailability;
import androidx.camera.core.internal.utils.ImageUtil;
import androidx.core.util.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

final class ImageSaver
implements Runnable {
    private static final String TAG = "ImageSaver";
    private static final String TEMP_FILE_PREFIX = "CameraX";
    private static final String TEMP_FILE_SUFFIX = ".tmp";
    private static final int COPY_BUFFER_SIZE = 1024;
    private static final int PENDING = 1;
    private static final int NOT_PENDING = 0;
    private final ImageProxy mImage;
    private final int mOrientation;
    @NonNull
    private final ImageCapture.OutputFileOptions mOutputFileOptions;
    private final Executor mUserCallbackExecutor;
    private final OnImageSavedCallback mCallback;
    private final Executor mSequentialIoExecutor;

    ImageSaver(ImageProxy image, @NonNull ImageCapture.OutputFileOptions outputFileOptions, int orientation, Executor userCallbackExecutor, Executor sequentialIoExecutor, OnImageSavedCallback callback) {
        this.mImage = image;
        this.mOutputFileOptions = outputFileOptions;
        this.mOrientation = orientation;
        this.mCallback = callback;
        this.mUserCallbackExecutor = userCallbackExecutor;
        this.mSequentialIoExecutor = sequentialIoExecutor;
    }

    @Override
    public void run() {
        File tempFile = this.saveImageToTempFile();
        if (tempFile != null) {
            this.mSequentialIoExecutor.execute(() -> this.copyTempFileToDestination(tempFile));
        }
    }

    @Nullable
    private File saveImageToTempFile() {
        File tempFile;
        try {
            tempFile = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
        }
        catch (IOException e) {
            this.postError(SaveError.FILE_IO_FAILED, "Failed to create temp file", e);
            return null;
        }
        SaveError saveError = null;
        String errorMessage = null;
        Exception exception = null;
        try (ImageProxy imageToClose = this.mImage;
             FileOutputStream output = new FileOutputStream(tempFile);){
            byte[] bytes = ImageUtil.imageToJpegByteArray(this.mImage);
            output.write(bytes);
            Exif exif = Exif.createFromFile(tempFile);
            exif.attachTimestamp();
            if (new ExifRotationAvailability().shouldUseExifOrientation(this.mImage)) {
                ByteBuffer buffer = this.mImage.getPlanes()[0].getBuffer();
                buffer.rewind();
                byte[] data = new byte[buffer.capacity()];
                buffer.get(data);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
                Exif originalExif = Exif.createFromInputStream(inputStream);
                exif.setOrientation(originalExif.getOrientation());
            } else {
                exif.rotate(this.mOrientation);
            }
            ImageCapture.Metadata metadata = this.mOutputFileOptions.getMetadata();
            if (metadata.isReversedHorizontal()) {
                exif.flipHorizontally();
            }
            if (metadata.isReversedVertical()) {
                exif.flipVertically();
            }
            if (metadata.getLocation() != null) {
                exif.attachLocation(this.mOutputFileOptions.getMetadata().getLocation());
            }
            exif.save();
        }
        catch (IOException | IllegalArgumentException e) {
            saveError = SaveError.FILE_IO_FAILED;
            errorMessage = "Failed to write temp file";
            exception = e;
        }
        catch (ImageUtil.CodecFailedException e) {
            switch (e.getFailureType()) {
                case ENCODE_FAILED: {
                    saveError = SaveError.ENCODE_FAILED;
                    errorMessage = "Failed to encode mImage";
                    break;
                }
                case DECODE_FAILED: {
                    saveError = SaveError.CROP_FAILED;
                    errorMessage = "Failed to crop mImage";
                    break;
                }
                default: {
                    saveError = SaveError.UNKNOWN;
                    errorMessage = "Failed to transcode mImage";
                }
            }
            exception = e;
        }
        if (saveError != null) {
            this.postError(saveError, errorMessage, exception);
            tempFile.delete();
            return null;
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyTempFileToDestination(@NonNull File tempFile) {
        Uri outputUri;
        Exception exception;
        String errorMessage;
        SaveError saveError;
        block17: {
            Preconditions.checkNotNull((Object)tempFile);
            saveError = null;
            errorMessage = null;
            exception = null;
            outputUri = null;
            try {
                if (this.isSaveToMediaStore()) {
                    ContentValues values = this.mOutputFileOptions.getContentValues() != null ? new ContentValues(this.mOutputFileOptions.getContentValues()) : new ContentValues();
                    this.setContentValuePending(values, 1);
                    outputUri = this.mOutputFileOptions.getContentResolver().insert(this.mOutputFileOptions.getSaveCollection(), values);
                    if (outputUri == null) {
                        saveError = SaveError.FILE_IO_FAILED;
                        errorMessage = "Failed to insert URI.";
                    } else {
                        if (!this.copyTempFileToUri(tempFile, outputUri)) {
                            saveError = SaveError.FILE_IO_FAILED;
                            errorMessage = "Failed to save to URI.";
                        }
                        this.setUriNotPending(outputUri);
                    }
                    break block17;
                }
                if (this.isSaveToOutputStream()) {
                    this.copyTempFileToOutputStream(tempFile, this.mOutputFileOptions.getOutputStream());
                    break block17;
                }
                if (!this.isSaveToFile()) break block17;
                try (FileOutputStream fileOutputStream = new FileOutputStream(this.mOutputFileOptions.getFile());){
                    FileLock fileLock = fileOutputStream.getChannel().lock();
                    this.copyTempFileToOutputStream(tempFile, fileOutputStream);
                    fileLock.release();
                }
            }
            catch (IOException | IllegalArgumentException e) {
                saveError = SaveError.FILE_IO_FAILED;
                errorMessage = "Failed to write destination file.";
                exception = e;
            }
            finally {
                tempFile.delete();
            }
        }
        if (saveError != null) {
            this.postError(saveError, errorMessage, exception);
        } else {
            this.postSuccess(outputUri);
        }
    }

    private boolean isSaveToMediaStore() {
        return this.mOutputFileOptions.getSaveCollection() != null && this.mOutputFileOptions.getContentResolver() != null && this.mOutputFileOptions.getContentValues() != null;
    }

    private boolean isSaveToFile() {
        return this.mOutputFileOptions.getFile() != null;
    }

    private boolean isSaveToOutputStream() {
        return this.mOutputFileOptions.getOutputStream() != null;
    }

    private void setUriNotPending(@NonNull Uri outputUri) {
        if (Build.VERSION.SDK_INT >= 29) {
            ContentValues values = new ContentValues();
            this.setContentValuePending(values, 0);
            this.mOutputFileOptions.getContentResolver().update(outputUri, values, null, null);
        }
    }

    private void setContentValuePending(@NonNull ContentValues values, int isPending) {
        if (Build.VERSION.SDK_INT >= 29) {
            values.put("is_pending", Integer.valueOf(isPending));
        }
    }

    private boolean copyTempFileToUri(@NonNull File tempFile, @NonNull Uri uri) throws IOException {
        try (OutputStream outputStream = this.mOutputFileOptions.getContentResolver().openOutputStream(uri);){
            if (outputStream == null) {
                boolean bl = false;
                return bl;
            }
            this.copyTempFileToOutputStream(tempFile, outputStream);
        }
        return true;
    }

    private void copyTempFileToOutputStream(@NonNull File tempFile, @NonNull OutputStream outputStream) throws IOException {
        try (FileInputStream in = new FileInputStream(tempFile);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
        }
    }

    private void postSuccess(@Nullable Uri outputUri) {
        try {
            this.mUserCallbackExecutor.execute(() -> this.mCallback.onImageSaved(new ImageCapture.OutputFileResults(outputUri)));
        }
        catch (RejectedExecutionException e) {
            Logger.e(TAG, "Application executor rejected executing OnImageSavedCallback.onImageSaved callback. Skipping.");
        }
    }

    private void postError(SaveError saveError, String message, @Nullable Throwable cause) {
        try {
            this.mUserCallbackExecutor.execute(() -> this.mCallback.onError(saveError, message, cause));
        }
        catch (RejectedExecutionException e) {
            Logger.e(TAG, "Application executor rejected executing OnImageSavedCallback.onError callback. Skipping.");
        }
    }

    public static interface OnImageSavedCallback {
        public void onImageSaved(@NonNull ImageCapture.OutputFileResults var1);

        public void onError(@NonNull SaveError var1, @NonNull String var2, @Nullable Throwable var3);
    }

    public static enum SaveError {
        FILE_IO_FAILED,
        ENCODE_FAILED,
        CROP_FAILED,
        UNKNOWN;

    }
}

