/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.os.Build;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Logger {
    private static final int MAX_TAG_LENGTH = 23;
    static final int DEFAULT_MIN_LOG_LEVEL = 3;
    private static int sMinLogLevel = 3;

    private Logger() {
    }

    static void setMinLogLevel(@IntRange(from=3L, to=6L) int logLevel) {
        sMinLogLevel = logLevel;
    }

    static void resetMinLogLevel() {
        sMinLogLevel = 3;
    }

    public static boolean isDebugEnabled(@NonNull String tag) {
        return sMinLogLevel <= 3 || Log.isLoggable((String)Logger.truncateTag(tag), (int)3);
    }

    public static boolean isInfoEnabled(@NonNull String tag) {
        return sMinLogLevel <= 4 || Log.isLoggable((String)Logger.truncateTag(tag), (int)4);
    }

    public static boolean isWarnEnabled(@NonNull String tag) {
        return sMinLogLevel <= 5 || Log.isLoggable((String)Logger.truncateTag(tag), (int)5);
    }

    public static boolean isErrorEnabled(@NonNull String tag) {
        return sMinLogLevel <= 6 || Log.isLoggable((String)Logger.truncateTag(tag), (int)6);
    }

    public static void d(@NonNull String tag, @NonNull String message) {
        Logger.d(tag, message, null);
    }

    public static void d(@NonNull String tag, @NonNull String message, @Nullable Throwable throwable) {
        if (Logger.isDebugEnabled(tag)) {
            Log.d((String)Logger.truncateTag(tag), (String)message, (Throwable)throwable);
        }
    }

    public static void i(@NonNull String tag, @NonNull String message) {
        Logger.i(tag, message, null);
    }

    public static void i(@NonNull String tag, @NonNull String message, @Nullable Throwable throwable) {
        if (Logger.isInfoEnabled(tag)) {
            Log.i((String)Logger.truncateTag(tag), (String)message, (Throwable)throwable);
        }
    }

    public static void w(@NonNull String tag, @NonNull String message) {
        Logger.w(tag, message, null);
    }

    public static void w(@NonNull String tag, @NonNull String message, @Nullable Throwable throwable) {
        if (Logger.isWarnEnabled(tag)) {
            Log.w((String)Logger.truncateTag(tag), (String)message, (Throwable)throwable);
        }
    }

    public static void e(@NonNull String tag, @NonNull String message) {
        Logger.e(tag, message, null);
    }

    public static void e(@NonNull String tag, @NonNull String message, @Nullable Throwable throwable) {
        if (Logger.isErrorEnabled(tag)) {
            Log.e((String)Logger.truncateTag(tag), (String)message, (Throwable)throwable);
        }
    }

    @NonNull
    private static String truncateTag(@NonNull String tag) {
        if (23 < tag.length() && Build.VERSION.SDK_INT < 24) {
            return tag.substring(0, 23);
        }
        return tag;
    }
}

