/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.os.Handler;
import android.os.Looper;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Logger;
import androidx.camera.core.MetadataImageReader;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.CaptureStage;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.SingleImageProxyBundle;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ScheduledExecutorService;

final class ProcessingSurface
extends DeferrableSurface {
    private static final String TAG = "ProcessingSurfaceTextur";
    final Object mLock = new Object();
    private final ImageReaderProxy.OnImageAvailableListener mTransformedListener = reader -> {
        Object object = this.mLock;
        synchronized (object) {
            this.imageIncoming(reader);
        }
    };
    @GuardedBy(value="mLock")
    boolean mReleased = false;
    @NonNull
    private final Size mResolution;
    @GuardedBy(value="mLock")
    final MetadataImageReader mInputImageReader;
    @GuardedBy(value="mLock")
    final Surface mInputSurface;
    private final Handler mImageReaderHandler;
    private static final int MAX_IMAGES = 2;
    final CaptureStage mCaptureStage;
    @NonNull
    @GuardedBy(value="mLock")
    final CaptureProcessor mCaptureProcessor;
    private final CameraCaptureCallback mCameraCaptureCallback;
    private final DeferrableSurface mOutputDeferrableSurface;
    private String mTagBundleKey;

    ProcessingSurface(int width, int height, int format, @Nullable Handler handler, @NonNull CaptureStage captureStage, @NonNull CaptureProcessor captureProcessor, @NonNull DeferrableSurface outputSurface, @NonNull String tagBundleKey) {
        this.mResolution = new Size(width, height);
        if (handler != null) {
            this.mImageReaderHandler = handler;
        } else {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalStateException("Creating a ProcessingSurface requires a non-null Handler, or be created  on a thread with a Looper.");
            }
            this.mImageReaderHandler = new Handler(looper);
        }
        ScheduledExecutorService executor = CameraXExecutors.newHandlerExecutor(this.mImageReaderHandler);
        this.mInputImageReader = new MetadataImageReader(width, height, format, 2);
        this.mInputImageReader.setOnImageAvailableListener(this.mTransformedListener, executor);
        this.mInputSurface = this.mInputImageReader.getSurface();
        this.mCameraCaptureCallback = this.mInputImageReader.getCameraCaptureCallback();
        this.mCaptureProcessor = captureProcessor;
        this.mCaptureProcessor.onResolutionUpdate(this.mResolution);
        this.mCaptureStage = captureStage;
        this.mOutputDeferrableSurface = outputSurface;
        this.mTagBundleKey = tagBundleKey;
        Futures.addCallback(outputSurface.getSurface(), new FutureCallback<Surface>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(@Nullable Surface surface) {
                Object object = ProcessingSurface.this.mLock;
                synchronized (object) {
                    ProcessingSurface.this.mCaptureProcessor.onOutputSurface(surface, 1);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                Logger.e(ProcessingSurface.TAG, "Failed to extract Listenable<Surface>.", t);
            }
        }, CameraXExecutors.directExecutor());
        this.getTerminationFuture().addListener(this::release, CameraXExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ListenableFuture<Surface> provideSurface() {
        Object object = this.mLock;
        synchronized (object) {
            return Futures.immediateFuture(this.mInputSurface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    CameraCaptureCallback getCameraCaptureCallback() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mReleased) {
                throw new IllegalStateException("ProcessingSurface already released!");
            }
            return this.mCameraCaptureCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mReleased) {
                return;
            }
            this.mInputImageReader.close();
            this.mInputSurface.release();
            this.mOutputDeferrableSurface.close();
            this.mReleased = true;
        }
    }

    @GuardedBy(value="mLock")
    void imageIncoming(ImageReaderProxy imageReader) {
        if (this.mReleased) {
            return;
        }
        ImageProxy image = null;
        try {
            image = imageReader.acquireNextImage();
        }
        catch (IllegalStateException e) {
            Logger.e(TAG, "Failed to acquire next image.", e);
        }
        if (image == null) {
            return;
        }
        ImageInfo imageInfo = image.getImageInfo();
        if (imageInfo == null) {
            image.close();
            return;
        }
        Integer tagValue = imageInfo.getTagBundle().getTag(this.mTagBundleKey);
        if (tagValue == null) {
            image.close();
            return;
        }
        if (this.mCaptureStage.getId() != tagValue.intValue()) {
            Logger.w(TAG, "ImageProxyBundle does not contain this id: " + tagValue);
            image.close();
        } else {
            SingleImageProxyBundle imageProxyBundle = new SingleImageProxyBundle(image, this.mTagBundleKey);
            this.mCaptureProcessor.process(imageProxyBundle);
            imageProxyBundle.close();
        }
    }
}

