/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.annotation.SuppressLint;
import android.graphics.Rect;
import android.util.Size;
import androidx.annotation.CallSuper;
import androidx.annotation.GuardedBy;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.utils.UseCaseConfigUtil;
import androidx.core.util.Preconditions;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public abstract class UseCase {
    private final Set<StateChangeCallback> mStateChangeCallbacks = new HashSet<StateChangeCallback>();
    private final Object mCameraLock = new Object();
    private State mState = State.INACTIVE;
    @Nullable
    private UseCaseConfig<?> mExtendedConfig;
    @NonNull
    private UseCaseConfig<?> mUseCaseConfig;
    @NonNull
    private UseCaseConfig<?> mCurrentConfig;
    private Size mAttachedResolution;
    @Nullable
    private UseCaseConfig<?> mCameraConfig;
    @Nullable
    private Rect mViewPortCropRect;
    @GuardedBy(value="mCameraLock")
    private CameraInternal mCamera;
    private SessionConfig mAttachedSessionConfig = SessionConfig.defaultEmptySessionConfig();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected UseCase(@NonNull UseCaseConfig<?> currentConfig) {
        this.mUseCaseConfig = currentConfig;
        this.mCurrentConfig = currentConfig;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public abstract UseCaseConfig<?> getDefaultConfig(boolean var1, @NonNull UseCaseConfigFactory var2);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public abstract UseCaseConfig.Builder<?, ?, ?> getUseCaseConfigBuilder(@NonNull Config var1);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public UseCaseConfig<?> mergeConfigs(@NonNull CameraInfoInternal cameraInfo, @Nullable UseCaseConfig<?> extendedConfig, @Nullable UseCaseConfig<?> cameraDefaultConfig) {
        Config.Option<?> objectOpt;
        MutableOptionsBundle mergedConfig;
        if (cameraDefaultConfig != null) {
            mergedConfig = MutableOptionsBundle.from(cameraDefaultConfig);
            mergedConfig.removeOption(TargetConfig.OPTION_TARGET_NAME);
        } else {
            mergedConfig = MutableOptionsBundle.create();
        }
        Iterator<Config.Option<?>> iterator = this.mUseCaseConfig.listOptions().iterator();
        while (iterator.hasNext()) {
            Config.Option<?> opt;
            objectOpt = opt = iterator.next();
            mergedConfig.insertOption(objectOpt, this.mUseCaseConfig.getOptionPriority(opt), this.mUseCaseConfig.retrieveOption(objectOpt));
        }
        if (extendedConfig != null) {
            for (Config.Option<?> opt : extendedConfig.listOptions()) {
                objectOpt = opt;
                if (objectOpt.getId().equals(TargetConfig.OPTION_TARGET_NAME.getId())) continue;
                mergedConfig.insertOption(objectOpt, extendedConfig.getOptionPriority(opt), extendedConfig.retrieveOption(objectOpt));
            }
        }
        if (mergedConfig.containsOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION) && mergedConfig.containsOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO)) {
            mergedConfig.removeOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO);
        }
        return this.onMergeConfig(cameraInfo, this.getUseCaseConfigBuilder(mergedConfig));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    UseCaseConfig<?> onMergeConfig(@NonNull CameraInfoInternal cameraInfo, @NonNull UseCaseConfig.Builder<?, ?, ?> builder) {
        return builder.getUseCaseConfig();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected boolean setTargetRotationInternal(int targetRotation) {
        ImageOutputConfig oldConfig = (ImageOutputConfig)((Object)this.getCurrentConfig());
        int oldRotation = oldConfig.getTargetRotation(-1);
        if (oldRotation == -1 || oldRotation != targetRotation) {
            UseCaseConfig.Builder<?, ?, ?> builder = this.getUseCaseConfigBuilder(this.mUseCaseConfig);
            UseCaseConfigUtil.updateTargetRotationAndRelatedConfigs(builder, targetRotation);
            this.mUseCaseConfig = builder.getUseCaseConfig();
            CameraInternal camera = this.getCamera();
            this.mCurrentConfig = camera == null ? this.mUseCaseConfig : this.mergeConfigs(camera.getCameraInfoInternal(), this.mExtendedConfig, this.mCameraConfig);
            return true;
        }
        return false;
    }

    @SuppressLint(value={"WrongConstant"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected int getTargetRotationInternal() {
        return ((ImageOutputConfig)((Object)this.mCurrentConfig)).getTargetRotation(0);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @IntRange(from=0L, to=359L)
    protected int getRelativeRotation(@NonNull CameraInternal cameraInternal) {
        return cameraInternal.getCameraInfoInternal().getSensorRotationDegrees(this.getTargetRotationInternal());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void updateSessionConfig(@NonNull SessionConfig sessionConfig) {
        this.mAttachedSessionConfig = sessionConfig;
    }

    private void addStateChangeCallback(@NonNull StateChangeCallback callback) {
        this.mStateChangeCallbacks.add(callback);
    }

    private void removeStateChangeCallback(@NonNull StateChangeCallback callback) {
        this.mStateChangeCallbacks.remove(callback);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public SessionConfig getSessionConfig() {
        return this.mAttachedSessionConfig;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected final void notifyActive() {
        this.mState = State.ACTIVE;
        this.notifyState();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected final void notifyInactive() {
        this.mState = State.INACTIVE;
        this.notifyState();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected final void notifyUpdated() {
        for (StateChangeCallback stateChangeCallback : this.mStateChangeCallbacks) {
            stateChangeCallback.onUseCaseUpdated(this);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected final void notifyReset() {
        for (StateChangeCallback stateChangeCallback : this.mStateChangeCallbacks) {
            stateChangeCallback.onUseCaseReset(this);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void notifyState() {
        switch (this.mState) {
            case INACTIVE: {
                for (StateChangeCallback stateChangeCallback : this.mStateChangeCallbacks) {
                    stateChangeCallback.onUseCaseInactive(this);
                }
                break;
            }
            case ACTIVE: {
                for (StateChangeCallback stateChangeCallback : this.mStateChangeCallbacks) {
                    stateChangeCallback.onUseCaseActive(this);
                }
                break;
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected String getCameraId() {
        return ((CameraInternal)Preconditions.checkNotNull((Object)this.getCamera(), (Object)("No camera attached to use case: " + this))).getCameraInfoInternal().getCameraId();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected boolean isCurrentCamera(@NonNull String cameraId) {
        if (this.getCamera() == null) {
            return false;
        }
        return Objects.equals(cameraId, this.getCameraId());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public String getName() {
        return this.mCurrentConfig.getTargetName("<UnknownUseCase-" + this.hashCode() + ">");
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public UseCaseConfig<?> getCurrentConfig() {
        return this.mCurrentConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CameraInternal getCamera() {
        Object object = this.mCameraLock;
        synchronized (object) {
            return this.mCamera;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Size getAttachedSurfaceResolution() {
        return this.mAttachedResolution;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void updateSuggestedResolution(@NonNull Size suggestedResolution) {
        this.mAttachedResolution = this.onSuggestedResolutionUpdated(suggestedResolution);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected abstract Size onSuggestedResolutionUpdated(@NonNull Size var1);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void onCameraControlReady() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"WrongConstant"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onAttach(@NonNull CameraInternal camera, @Nullable UseCaseConfig<?> extendedConfig, @Nullable UseCaseConfig<?> cameraConfig) {
        Object object = this.mCameraLock;
        synchronized (object) {
            this.mCamera = camera;
            this.addStateChangeCallback(camera);
        }
        this.mExtendedConfig = extendedConfig;
        this.mCameraConfig = cameraConfig;
        this.mCurrentConfig = this.mergeConfigs(camera.getCameraInfoInternal(), this.mExtendedConfig, this.mCameraConfig);
        EventCallback eventCallback = this.mCurrentConfig.getUseCaseEventCallback(null);
        if (eventCallback != null) {
            eventCallback.onAttach(camera.getCameraInfoInternal());
        }
        this.onAttached();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onAttached() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void onDetach(@NonNull CameraInternal camera) {
        this.onDetached();
        EventCallback eventCallback = this.mCurrentConfig.getUseCaseEventCallback(null);
        if (eventCallback != null) {
            eventCallback.onDetach();
        }
        Object object = this.mCameraLock;
        synchronized (object) {
            Preconditions.checkArgument((camera == this.mCamera ? 1 : 0) != 0);
            this.removeStateChangeCallback(this.mCamera);
            this.mCamera = null;
        }
        this.mAttachedResolution = null;
        this.mViewPortCropRect = null;
        this.mCurrentConfig = this.mUseCaseConfig;
        this.mExtendedConfig = null;
        this.mCameraConfig = null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onDetached() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @CallSuper
    public void onStateAttached() {
        this.onCameraControlReady();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onStateDetached() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected CameraControlInternal getCameraControl() {
        Object object = this.mCameraLock;
        synchronized (object) {
            if (this.mCamera == null) {
                return CameraControlInternal.DEFAULT_EMPTY_INSTANCE;
            }
            return this.mCamera.getCameraControlInternal();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setViewPortCropRect(@NonNull Rect viewPortCropRect) {
        this.mViewPortCropRect = viewPortCropRect;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public Rect getViewPortCropRect() {
        return this.mViewPortCropRect;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getImageFormat() {
        return this.mCurrentConfig.getInputFormat();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface EventCallback {
        public void onAttach(@NonNull CameraInfo var1);

        public void onDetach();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface StateChangeCallback {
        public void onUseCaseActive(@NonNull UseCase var1);

        public void onUseCaseInactive(@NonNull UseCase var1);

        public void onUseCaseUpdated(@NonNull UseCase var1);

        public void onUseCaseReset(@NonNull UseCase var1);
    }

    static enum State {
        ACTIVE,
        INACTIVE;

    }
}

