/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.camera.core.Camera;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraInternal;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public final class CameraStateRegistry {
    private static final String TAG = "CameraStateRegistry";
    private final StringBuilder mDebugString = new StringBuilder();
    private final Object mLock = new Object();
    private final int mMaxAllowedOpenedCameras;
    @GuardedBy(value="mLock")
    private final Map<Camera, CameraRegistration> mCameraStates = new HashMap<Camera, CameraRegistration>();
    @GuardedBy(value="mLock")
    private int mAvailableCameras;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraStateRegistry(int maxAllowedOpenedCameras) {
        this.mMaxAllowedOpenedCameras = maxAllowedOpenedCameras;
        String string2 = "mLock";
        synchronized ("mLock") {
            this.mAvailableCameras = this.mMaxAllowedOpenedCameras;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCamera(@NonNull Camera camera, @NonNull Executor notifyExecutor, @NonNull OnOpenAvailableListener cameraAvailableListener) {
        Object object = this.mLock;
        synchronized (object) {
            Preconditions.checkState((!this.mCameraStates.containsKey(camera) ? 1 : 0) != 0, (String)("Camera is already registered: " + camera));
            this.mCameraStates.put(camera, new CameraRegistration(null, notifyExecutor, cameraAvailableListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryOpenCamera(@NonNull Camera camera) {
        Object object = this.mLock;
        synchronized (object) {
            CameraRegistration registration = (CameraRegistration)Preconditions.checkNotNull((Object)this.mCameraStates.get(camera), (Object)"Camera must first be registered with registerCamera()");
            boolean success = false;
            if (Logger.isDebugEnabled(TAG)) {
                this.mDebugString.setLength(0);
                this.mDebugString.append(String.format(Locale.US, "tryOpenCamera(%s) [Available Cameras: %d, Already Open: %b (Previous state: %s)]", new Object[]{camera, this.mAvailableCameras, CameraStateRegistry.isOpen(registration.getState()), registration.getState()}));
            }
            if (this.mAvailableCameras > 0 || CameraStateRegistry.isOpen(registration.getState())) {
                registration.setState(CameraInternal.State.OPENING);
                success = true;
            }
            if (Logger.isDebugEnabled(TAG)) {
                this.mDebugString.append(String.format(Locale.US, " --> %s", success ? "SUCCESS" : "FAIL"));
                Logger.d(TAG, this.mDebugString.toString());
            }
            if (success) {
                this.recalculateAvailableCameras();
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void markCameraState(@NonNull Camera camera, @NonNull CameraInternal.State state) {
        List<Object> camerasToNotify = null;
        Iterator iterator = this.mLock;
        synchronized (iterator) {
            void var5_8;
            Object var5_5 = null;
            int previousAvailableCameras = this.mAvailableCameras;
            if (state == CameraInternal.State.RELEASED) {
                CameraInternal.State state2 = this.unregisterCamera(camera);
            } else {
                CameraInternal.State state3 = this.updateAndVerifyState(camera, state);
            }
            if (var5_8 == state) {
                return;
            }
            if (previousAvailableCameras < 1 && this.mAvailableCameras > 0) {
                camerasToNotify = new ArrayList();
                for (Map.Entry<Camera, CameraRegistration> entry : this.mCameraStates.entrySet()) {
                    if (entry.getValue().getState() != CameraInternal.State.PENDING_OPEN) continue;
                    camerasToNotify.add(entry.getValue());
                }
            } else if (state == CameraInternal.State.PENDING_OPEN && this.mAvailableCameras > 0) {
                camerasToNotify = Collections.singletonList(this.mCameraStates.get(camera));
            }
        }
        if (camerasToNotify != null) {
            for (CameraRegistration cameraRegistration : camerasToNotify) {
                cameraRegistration.notifyListener();
            }
        }
    }

    @GuardedBy(value="mLock")
    @Nullable
    private CameraInternal.State unregisterCamera(Camera camera) {
        CameraRegistration registration = this.mCameraStates.remove(camera);
        if (registration != null) {
            this.recalculateAvailableCameras();
            return registration.getState();
        }
        return null;
    }

    @GuardedBy(value="mLock")
    @Nullable
    private CameraInternal.State updateAndVerifyState(@NonNull Camera camera, @NonNull CameraInternal.State state) {
        CameraInternal.State previousState = ((CameraRegistration)Preconditions.checkNotNull((Object)this.mCameraStates.get(camera), (Object)"Cannot update state of camera which has not yet been registered. Register with CameraAvailabilityRegistry.registerCamera()")).setState(state);
        if (state == CameraInternal.State.OPENING) {
            Preconditions.checkState((CameraStateRegistry.isOpen(state) || previousState == CameraInternal.State.OPENING ? 1 : 0) != 0, (String)"Cannot mark camera as opening until camera was successful at calling CameraAvailabilityRegistry.tryOpen()");
        }
        if (previousState != state) {
            this.recalculateAvailableCameras();
        }
        return previousState;
    }

    private static boolean isOpen(@Nullable CameraInternal.State state) {
        return state != null && state.holdsCameraSlot();
    }

    @WorkerThread
    @GuardedBy(value="mLock")
    private void recalculateAvailableCameras() {
        if (Logger.isDebugEnabled(TAG)) {
            this.mDebugString.setLength(0);
            this.mDebugString.append("Recalculating open cameras:\n");
            this.mDebugString.append(String.format(Locale.US, "%-45s%-22s\n", "Camera", "State"));
            this.mDebugString.append("-------------------------------------------------------------------\n");
        }
        int openCount = 0;
        for (Map.Entry<Camera, CameraRegistration> entry : this.mCameraStates.entrySet()) {
            if (Logger.isDebugEnabled(TAG)) {
                String stateString = entry.getValue().getState() != null ? entry.getValue().getState().toString() : "UNKNOWN";
                this.mDebugString.append(String.format(Locale.US, "%-45s%-22s\n", entry.getKey().toString(), stateString));
            }
            if (!CameraStateRegistry.isOpen(entry.getValue().getState())) continue;
            ++openCount;
        }
        if (Logger.isDebugEnabled(TAG)) {
            this.mDebugString.append("-------------------------------------------------------------------\n");
            this.mDebugString.append(String.format(Locale.US, "Open count: %d (Max allowed: %d)", openCount, this.mMaxAllowedOpenedCameras));
            Logger.d(TAG, this.mDebugString.toString());
        }
        this.mAvailableCameras = Math.max(this.mMaxAllowedOpenedCameras - openCount, 0);
    }

    private static class CameraRegistration {
        private CameraInternal.State mState;
        private final Executor mNotifyExecutor;
        private final OnOpenAvailableListener mCameraAvailableListener;

        CameraRegistration(@Nullable CameraInternal.State initialState, @NonNull Executor notifyExecutor, @NonNull OnOpenAvailableListener cameraAvailableListener) {
            this.mState = initialState;
            this.mNotifyExecutor = notifyExecutor;
            this.mCameraAvailableListener = cameraAvailableListener;
        }

        CameraInternal.State setState(@Nullable CameraInternal.State state) {
            CameraInternal.State previousState = this.mState;
            this.mState = state;
            return previousState;
        }

        CameraInternal.State getState() {
            return this.mState;
        }

        void notifyListener() {
            try {
                this.mNotifyExecutor.execute(this.mCameraAvailableListener::onOpenAvailable);
            }
            catch (RejectedExecutionException e) {
                Logger.e(CameraStateRegistry.TAG, "Unable to notify camera.", e);
            }
        }
    }

    public static interface OnOpenAvailableListener {
        public void onOpenAvailable();
    }
}

