/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.compat;

import android.media.ImageWriter;
import android.os.Build;
import android.view.Surface;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.internal.compat.ImageWriterCompatApi26Impl;
import androidx.camera.core.internal.compat.ImageWriterCompatApi29Impl;

@RequiresApi(value=26)
public final class ImageWriterCompat {
    @NonNull
    public static ImageWriter newInstance(@NonNull Surface surface, @IntRange(from=1L) int maxImages, int format) {
        if (Build.VERSION.SDK_INT >= 26) {
            return ImageWriterCompatApi26Impl.newInstance(surface, maxImages, format);
        }
        if (Build.VERSION.SDK_INT >= 29) {
            return ImageWriterCompatApi29Impl.newInstance(surface, maxImages, format);
        }
        throw new RuntimeException("Unable to call newInstance(Surface, int, int) on API " + Build.VERSION.SDK_INT + ". Version 26 or higher required.");
    }

    private ImageWriterCompat() {
    }
}

