/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImmutableImageInfo;
import androidx.camera.core.Logger;
import androidx.camera.core.SettableImageProxy;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.os.OperationCanceledException;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;

abstract class ImageAnalysisAbstractAnalyzer
implements ImageReaderProxy.OnImageAvailableListener {
    private static final String TAG = "ImageAnalysisAnalyzer";
    @GuardedBy(value="mAnalyzerLock")
    private ImageAnalysis.Analyzer mSubscribedAnalyzer;
    private volatile int mRelativeRotation;
    @GuardedBy(value="mAnalyzerLock")
    private Executor mUserExecutor;
    private final Object mAnalyzerLock = new Object();
    protected boolean mIsAttached = true;

    ImageAnalysisAbstractAnalyzer() {
    }

    @Override
    public void onImageAvailable(@NonNull ImageReaderProxy imageReaderProxy) {
        try {
            ImageProxy imageProxy = this.acquireImage(imageReaderProxy);
            if (imageProxy != null) {
                this.onValidImageAvailable(imageProxy);
            }
        }
        catch (IllegalStateException e) {
            Logger.e(TAG, "Failed to acquire image.", e);
        }
    }

    @Nullable
    abstract ImageProxy acquireImage(@NonNull ImageReaderProxy var1);

    abstract void onValidImageAvailable(@NonNull ImageProxy var1);

    abstract void clearCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<Void> analyzeImage(ImageProxy imageProxy) {
        ImageAnalysis.Analyzer analyzer;
        Executor executor;
        Object object = this.mAnalyzerLock;
        synchronized (object) {
            executor = this.mUserExecutor;
            analyzer = this.mSubscribedAnalyzer;
        }
        ListenableFuture future = analyzer != null && executor != null ? CallbackToFutureAdapter.getFuture(completer -> {
            executor.execute(() -> {
                if (this.mIsAttached) {
                    ImageInfo imageInfo = ImmutableImageInfo.create(imageProxy.getImageInfo().getTagBundle(), imageProxy.getImageInfo().getTimestamp(), this.mRelativeRotation);
                    analyzer.analyze(new SettableImageProxy(imageProxy, imageInfo));
                    completer.set(null);
                } else {
                    completer.setException((Throwable)new OperationCanceledException("ImageAnalysis is detached"));
                }
            });
            return "analyzeImage";
        }) : Futures.immediateFailedFuture((Throwable)new OperationCanceledException("No analyzer or executor currently set."));
        return future;
    }

    void setRelativeRotation(int relativeRotation) {
        this.mRelativeRotation = relativeRotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAnalyzer(@Nullable Executor userExecutor, @Nullable ImageAnalysis.Analyzer subscribedAnalyzer) {
        Object object = this.mAnalyzerLock;
        synchronized (object) {
            if (subscribedAnalyzer == null) {
                this.clearCache();
            }
            this.mSubscribedAnalyzer = subscribedAnalyzer;
            this.mUserExecutor = userExecutor;
        }
    }

    void attach() {
        this.mIsAttached = true;
    }

    void detach() {
        this.mIsAttached = false;
        this.clearCache();
    }
}

