/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.AutoValue_StateObservable_ErrorWrapper;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class StateObservable<T>
implements Observable<T> {
    private static final int INITIAL_VERSION = 0;
    private final Object mLock = new Object();
    private final AtomicReference<Object> mState;
    @GuardedBy(value="mLock")
    private int mVersion = 0;
    @GuardedBy(value="mLock")
    private boolean mUpdating = false;
    @GuardedBy(value="mLock")
    private final Map<Observable.Observer<? super T>, ObserverWrapper<T>> mWrapperMap = new HashMap<Observable.Observer<? super T>, ObserverWrapper<T>>();
    @GuardedBy(value="mLock")
    private final CopyOnWriteArraySet<ObserverWrapper<T>> mNotifySet = new CopyOnWriteArraySet();

    StateObservable(@Nullable Object initialState, boolean isError) {
        if (isError) {
            Preconditions.checkArgument((boolean)(initialState instanceof Throwable), (Object)"Initial errors must be Throwable");
            this.mState = new AtomicReference<ErrorWrapper>(ErrorWrapper.wrap((Throwable)initialState));
        } else {
            this.mState = new AtomicReference<Object>(initialState);
        }
    }

    void updateState(@Nullable T state) {
        this.updateStateInternal(state);
    }

    void updateStateAsError(@NonNull Throwable error) {
        this.updateStateInternal(ErrorWrapper.wrap(error));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStateInternal(@Nullable Object newState) {
        Iterator<ObserverWrapper<T>> notifyIter;
        int currentVersion;
        Object object = this.mLock;
        synchronized (object) {
            Object oldState = this.mState.getAndSet(newState);
            if (Objects.equals(oldState, newState)) {
                return;
            }
            currentVersion = ++this.mVersion;
            if (this.mUpdating) {
                return;
            }
            this.mUpdating = true;
            notifyIter = this.mNotifySet.iterator();
        }
        while (true) {
            if (notifyIter.hasNext()) {
                notifyIter.next().update(currentVersion);
                continue;
            }
            object = this.mLock;
            synchronized (object) {
                if (this.mVersion == currentVersion) {
                    this.mUpdating = false;
                    break;
                }
                notifyIter = this.mNotifySet.iterator();
                currentVersion = this.mVersion;
            }
        }
    }

    @Override
    @NonNull
    public ListenableFuture<T> fetchData() {
        Object state = this.mState.get();
        if (state instanceof ErrorWrapper) {
            return Futures.immediateFailedFuture(((ErrorWrapper)state).getError());
        }
        return Futures.immediateFuture(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(@NonNull Executor executor, @NonNull Observable.Observer<? super T> observer) {
        ObserverWrapper<T> wrapper;
        Object object = this.mLock;
        synchronized (object) {
            this.removeObserverLocked(observer);
            wrapper = new ObserverWrapper<T>(this.mState, executor, observer);
            this.mWrapperMap.put(observer, wrapper);
            this.mNotifySet.add(wrapper);
        }
        wrapper.update(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObserver(@NonNull Observable.Observer<? super T> observer) {
        Object object = this.mLock;
        synchronized (object) {
            this.removeObserverLocked(observer);
        }
    }

    @GuardedBy(value="mLock")
    private void removeObserverLocked(@NonNull Observable.Observer<? super T> observer) {
        ObserverWrapper<T> wrapper = this.mWrapperMap.remove(observer);
        if (wrapper != null) {
            wrapper.close();
            this.mNotifySet.remove(wrapper);
        }
    }

    @AutoValue
    static abstract class ErrorWrapper {
        ErrorWrapper() {
        }

        @NonNull
        static ErrorWrapper wrap(@NonNull Throwable error) {
            return new AutoValue_StateObservable_ErrorWrapper(error);
        }

        @NonNull
        public abstract Throwable getError();
    }

    private static final class ObserverWrapper<T>
    implements Runnable {
        private static final Object NOT_SET = new Object();
        private static final int NO_VERSION = -1;
        private final Executor mExecutor;
        private final Observable.Observer<? super T> mObserver;
        private final AtomicBoolean mActive = new AtomicBoolean(true);
        private final AtomicReference<Object> mStateRef;
        private Object mLastState = NOT_SET;
        @GuardedBy(value="this")
        private int mLatestSignalledVersion = -1;
        @GuardedBy(value="this")
        private boolean mWrapperUpdating = false;

        ObserverWrapper(@NonNull AtomicReference<Object> stateRef, @NonNull Executor executor, @NonNull Observable.Observer<? super T> observer) {
            this.mStateRef = stateRef;
            this.mExecutor = executor;
            this.mObserver = observer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int currentVersion;
            Object newState;
            ObserverWrapper observerWrapper = this;
            synchronized (observerWrapper) {
                if (!this.mActive.get()) {
                    this.mWrapperUpdating = false;
                    return;
                }
                newState = this.mStateRef.get();
                currentVersion = this.mLatestSignalledVersion;
            }
            while (true) {
                if (!Objects.equals(this.mLastState, newState)) {
                    this.mLastState = newState;
                    if (newState instanceof ErrorWrapper) {
                        this.mObserver.onError(((ErrorWrapper)newState).getError());
                    } else {
                        this.mObserver.onNewData(newState);
                    }
                }
                observerWrapper = this;
                synchronized (observerWrapper) {
                    if (currentVersion == this.mLatestSignalledVersion || !this.mActive.get()) {
                        this.mWrapperUpdating = false;
                        break;
                    }
                    newState = this.mStateRef.get();
                    currentVersion = this.mLatestSignalledVersion;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update(int version) {
            ObserverWrapper observerWrapper = this;
            synchronized (observerWrapper) {
                if (!this.mActive.get()) {
                    return;
                }
                if (version <= this.mLatestSignalledVersion) {
                    return;
                }
                this.mLatestSignalledVersion = version;
                if (this.mWrapperUpdating) {
                    return;
                }
                this.mWrapperUpdating = true;
            }
            try {
                this.mExecutor.execute(this);
            }
            catch (Throwable t) {
                ObserverWrapper observerWrapper2 = this;
                synchronized (observerWrapper2) {
                    this.mWrapperUpdating = false;
                }
            }
        }

        void close() {
            this.mActive.set(false);
        }
    }
}

