/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.ArrayMap;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Map;
import java.util.Set;

public class TagBundle {
    protected final Map<String, Integer> mTagMap;
    private static final TagBundle EMPTY_TAGBUNDLE = new TagBundle((Map<String, Integer>)new ArrayMap());

    protected TagBundle(@NonNull Map<String, Integer> tagMap) {
        this.mTagMap = tagMap;
    }

    @NonNull
    public static TagBundle emptyBundle() {
        return EMPTY_TAGBUNDLE;
    }

    @NonNull
    public static TagBundle create(@NonNull Pair<String, Integer> source) {
        ArrayMap map = new ArrayMap();
        map.put((String)source.first, (Integer)source.second);
        return new TagBundle((Map<String, Integer>)map);
    }

    @NonNull
    public static TagBundle from(@NonNull TagBundle otherTagBundle) {
        ArrayMap tags = new ArrayMap();
        for (String key : otherTagBundle.listKeys()) {
            tags.put(key, otherTagBundle.getTag(key));
        }
        return new TagBundle((Map<String, Integer>)tags);
    }

    @Nullable
    public Integer getTag(@NonNull String key) {
        return this.mTagMap.get(key);
    }

    @NonNull
    public Set<String> listKeys() {
        return this.mTagMap.keySet();
    }
}

