/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.compat.workaround;

import android.media.MediaCodec;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.Preview;
import androidx.camera.core.VideoCapture;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.internal.compat.quirk.DeviceQuirks;
import androidx.camera.core.internal.compat.quirk.SurfaceOrderQuirk;
import java.util.Collections;
import java.util.List;

@RequiresApi(value=21)
public class SurfaceSorter {
    private static final int PRIORITY_PREVIEW_SURFACE = 0;
    private static final int PRIORITY_OTHERS = 1;
    private static final int PRIORITY_MEDIA_CODEC_SURFACE = 2;
    private final boolean mHasQuirk = DeviceQuirks.get(SurfaceOrderQuirk.class) != null;

    public void sort(@NonNull List<DeferrableSurface> surfaces) {
        if (!this.mHasQuirk) {
            return;
        }
        Collections.sort(surfaces, (surface1, surface2) -> {
            int p1 = this.getSurfacePriority((DeferrableSurface)surface1);
            int p2 = this.getSurfacePriority((DeferrableSurface)surface2);
            return p1 - p2;
        });
    }

    private int getSurfacePriority(@NonNull DeferrableSurface surface) {
        if (surface.getContainerClass() == MediaCodec.class || surface.getContainerClass() == VideoCapture.class) {
            return 2;
        }
        if (surface.getContainerClass() == Preview.class) {
            return 0;
        }
        return 1;
    }
}

