/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.ImageProcessor;
import androidx.camera.core.SurfaceProcessor;
import androidx.core.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(api=21)
public class CameraEffect {
    public static final int PREVIEW = 1;
    public static final int VIDEO_CAPTURE = 2;
    public static final int IMAGE_CAPTURE = 4;
    private final int mTargets;
    @NonNull
    private final Executor mProcessorExecutor;
    @Nullable
    private final SurfaceProcessor mSurfaceProcessor;
    @Nullable
    private final ImageProcessor mImageProcessor;

    protected CameraEffect(int targets, @NonNull Executor processorExecutor, @NonNull ImageProcessor imageProcessor) {
        this.mTargets = targets;
        this.mProcessorExecutor = processorExecutor;
        this.mSurfaceProcessor = null;
        this.mImageProcessor = imageProcessor;
    }

    protected CameraEffect(int targets, @NonNull Executor processorExecutor, @NonNull SurfaceProcessor surfaceProcessor) {
        this.mTargets = targets;
        this.mProcessorExecutor = processorExecutor;
        this.mSurfaceProcessor = surfaceProcessor;
        this.mImageProcessor = null;
    }

    public int getTargets() {
        return this.mTargets;
    }

    @NonNull
    public Executor getProcessorExecutor() {
        return this.mProcessorExecutor;
    }

    @Nullable
    public SurfaceProcessor getSurfaceProcessor() {
        return this.mSurfaceProcessor;
    }

    @Nullable
    public ImageProcessor getImageProcessor() {
        return this.mImageProcessor;
    }

    public static class Builder {
        private final int mTargets;
        @Nullable
        private Executor mProcessorExecutor;
        @Nullable
        private SurfaceProcessor mSurfaceProcessor;
        @Nullable
        private ImageProcessor mImageProcessor;

        public Builder(int targets) {
            this.mTargets = targets;
        }

        @NonNull
        public Builder setSurfaceProcessor(@NonNull Executor executor, @NonNull SurfaceProcessor processor) {
            this.mProcessorExecutor = executor;
            this.mSurfaceProcessor = processor;
            return this;
        }

        @NonNull
        public Builder setImageProcessor(@NonNull Executor executor, @NonNull ImageProcessor processor) {
            this.mProcessorExecutor = executor;
            this.mImageProcessor = processor;
            return this;
        }

        @NonNull
        public CameraEffect build() {
            Preconditions.checkState((this.mProcessorExecutor != null ? 1 : 0) != 0, (String)"Must have a executor");
            Preconditions.checkState((boolean)(this.mImageProcessor != null ^ this.mSurfaceProcessor != null), (String)"Must have one and only one processor");
            if (this.mSurfaceProcessor != null) {
                return new CameraEffect(this.mTargets, this.mProcessorExecutor, this.mSurfaceProcessor);
            }
            return new CameraEffect(this.mTargets, this.mProcessorExecutor, this.mImageProcessor);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface Targets {
    }
}

