/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.Pair;
import android.util.Size;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ExperimentalUseCaseApi;
import androidx.camera.core.ImageAnalysisAbstractAnalyzer;
import androidx.camera.core.ImageAnalysisBlockingAnalyzer;
import androidx.camera.core.ImageAnalysisNonBlockingAnalyzer;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxyProvider;
import androidx.camera.core.ImageReaderProxys;
import androidx.camera.core.ResolutionInfo;
import androidx.camera.core.SafeCloseImageReaderProxy;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageAnalysisConfig;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.ThreadConfig;
import androidx.camera.core.internal.compat.quirk.OnePixelShiftQuirk;
import androidx.core.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public final class ImageAnalysis
extends UseCase {
    public static final int STRATEGY_KEEP_ONLY_LATEST = 0;
    public static final int STRATEGY_BLOCK_PRODUCER = 1;
    public static final int OUTPUT_IMAGE_FORMAT_YUV_420_888 = 1;
    public static final int OUTPUT_IMAGE_FORMAT_RGBA_8888 = 2;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Defaults DEFAULT_CONFIG = new Defaults();
    private static final String TAG = "ImageAnalysis";
    private static final int NON_BLOCKING_IMAGE_DEPTH = 4;
    private static final int DEFAULT_BACKPRESSURE_STRATEGY = 0;
    private static final int DEFAULT_IMAGE_QUEUE_DEPTH = 6;
    private static final int DEFAULT_OUTPUT_IMAGE_FORMAT = 1;
    private static final Boolean DEFAULT_ONE_PIXEL_SHIFT_ENABLED = null;
    private static final boolean DEFAULT_OUTPUT_IMAGE_ROTATION_ENABLED = false;
    final ImageAnalysisAbstractAnalyzer mImageAnalysisAbstractAnalyzer;
    private final Object mAnalysisLock = new Object();
    @GuardedBy(value="mAnalysisLock")
    private Analyzer mSubscribedAnalyzer;
    @Nullable
    private DeferrableSurface mDeferrableSurface;
    public static final int COORDINATE_SYSTEM_ORIGINAL = 0;

    ImageAnalysis(@NonNull ImageAnalysisConfig config) {
        super(config);
        ImageAnalysisConfig combinedConfig = (ImageAnalysisConfig)this.getCurrentConfig();
        this.mImageAnalysisAbstractAnalyzer = combinedConfig.getBackpressureStrategy(0) == 1 ? new ImageAnalysisBlockingAnalyzer() : new ImageAnalysisNonBlockingAnalyzer(config.getBackgroundExecutor(CameraXExecutors.highPriorityExecutor()));
        this.mImageAnalysisAbstractAnalyzer.setOutputImageFormat(this.getOutputImageFormat());
        this.mImageAnalysisAbstractAnalyzer.setOutputImageRotationEnabled(this.isOutputImageRotationEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected UseCaseConfig<?> onMergeConfig(@NonNull CameraInfoInternal cameraInfo, @NonNull UseCaseConfig.Builder<?, ?, ?> builder) {
        Size analyzerResolution;
        Boolean isOnePixelShiftEnabled = this.getOnePixelShiftEnabled();
        boolean isOnePixelShiftIssueDevice = cameraInfo.getCameraQuirks().contains(OnePixelShiftQuirk.class);
        this.mImageAnalysisAbstractAnalyzer.setOnePixelShiftEnabled(isOnePixelShiftEnabled == null ? isOnePixelShiftIssueDevice : isOnePixelShiftEnabled);
        Object object = this.mAnalysisLock;
        synchronized (object) {
            analyzerResolution = this.mSubscribedAnalyzer != null ? this.mSubscribedAnalyzer.getDefaultTargetResolution() : null;
        }
        if (analyzerResolution != null && !builder.getUseCaseConfig().containsOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION)) {
            builder.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION, analyzerResolution);
        }
        return builder.getUseCaseConfig();
    }

    SessionConfig.Builder createPipeline(@NonNull String cameraId, @NonNull ImageAnalysisConfig config, @NonNull Size resolution) {
        SafeCloseImageReaderProxy processedImageReaderProxy;
        Threads.checkMainThread();
        Executor backgroundExecutor = (Executor)Preconditions.checkNotNull((Object)config.getBackgroundExecutor(CameraXExecutors.highPriorityExecutor()));
        int imageQueueDepth = this.getBackpressureStrategy() == 1 ? this.getImageQueueDepth() : 4;
        SafeCloseImageReaderProxy imageReaderProxy = config.getImageReaderProxyProvider() != null ? new SafeCloseImageReaderProxy(config.getImageReaderProxyProvider().newInstance(resolution.getWidth(), resolution.getHeight(), this.getImageFormat(), imageQueueDepth, 0L)) : new SafeCloseImageReaderProxy(ImageReaderProxys.createIsolatedReader(resolution.getWidth(), resolution.getHeight(), this.getImageFormat(), imageQueueDepth));
        boolean flipWH = this.getCamera() != null ? this.isFlipWH(this.getCamera()) : false;
        int width = flipWH ? resolution.getHeight() : resolution.getWidth();
        int height = flipWH ? resolution.getWidth() : resolution.getHeight();
        int format = this.getOutputImageFormat() == 2 ? 1 : 35;
        boolean isYuv2Rgb = this.getImageFormat() == 35 && this.getOutputImageFormat() == 2;
        boolean isYuvRotationOrPixelShift = this.getImageFormat() == 35 && (this.getCamera() != null && this.getRelativeRotation(this.getCamera()) != 0 || Boolean.TRUE.equals(this.getOnePixelShiftEnabled()));
        SafeCloseImageReaderProxy safeCloseImageReaderProxy = processedImageReaderProxy = isYuv2Rgb || isYuvRotationOrPixelShift ? new SafeCloseImageReaderProxy(ImageReaderProxys.createIsolatedReader(width, height, format, imageReaderProxy.getMaxImages())) : null;
        if (processedImageReaderProxy != null) {
            this.mImageAnalysisAbstractAnalyzer.setProcessedImageReaderProxy(processedImageReaderProxy);
        }
        this.tryUpdateRelativeRotation();
        imageReaderProxy.setOnImageAvailableListener(this.mImageAnalysisAbstractAnalyzer, backgroundExecutor);
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.Builder.createFrom(config);
        if (this.mDeferrableSurface != null) {
            this.mDeferrableSurface.close();
        }
        this.mDeferrableSurface = new ImmediateSurface(imageReaderProxy.getSurface(), resolution, this.getImageFormat());
        this.mDeferrableSurface.getTerminationFuture().addListener(() -> {
            imageReaderProxy.safeClose();
            if (processedImageReaderProxy != null) {
                processedImageReaderProxy.safeClose();
            }
        }, (Executor)CameraXExecutors.mainThreadExecutor());
        sessionConfigBuilder.addSurface(this.mDeferrableSurface);
        sessionConfigBuilder.addErrorListener((sessionConfig, error) -> {
            this.clearPipeline();
            this.mImageAnalysisAbstractAnalyzer.clearCache();
            if (this.isCurrentCamera(cameraId)) {
                SessionConfig.Builder errorSessionConfigBuilder = this.createPipeline(cameraId, config, resolution);
                this.updateSessionConfig(errorSessionConfigBuilder.build());
                this.notifyReset();
            }
        });
        return sessionConfigBuilder;
    }

    void clearPipeline() {
        Threads.checkMainThread();
        if (this.mDeferrableSurface != null) {
            this.mDeferrableSurface.close();
            this.mDeferrableSurface = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAnalyzer() {
        Object object = this.mAnalysisLock;
        synchronized (object) {
            this.mImageAnalysisAbstractAnalyzer.setAnalyzer(null, null);
            if (this.mSubscribedAnalyzer != null) {
                this.notifyInactive();
            }
            this.mSubscribedAnalyzer = null;
        }
    }

    public int getTargetRotation() {
        return this.getTargetRotationInternal();
    }

    public void setTargetRotation(int rotation) {
        if (this.setTargetRotationInternal(rotation)) {
            this.tryUpdateRelativeRotation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnalyzer(@NonNull Executor executor, @NonNull Analyzer analyzer) {
        Object object = this.mAnalysisLock;
        synchronized (object) {
            this.mImageAnalysisAbstractAnalyzer.setAnalyzer(executor, image -> analyzer.analyze(image));
            if (this.mSubscribedAnalyzer == null) {
                this.notifyActive();
            }
            this.mSubscribedAnalyzer = analyzer;
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setViewPortCropRect(@NonNull Rect viewPortCropRect) {
        super.setViewPortCropRect(viewPortCropRect);
        this.mImageAnalysisAbstractAnalyzer.setViewPortCropRect(viewPortCropRect);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setSensorToBufferTransformMatrix(@NonNull Matrix matrix) {
        super.setSensorToBufferTransformMatrix(matrix);
        this.mImageAnalysisAbstractAnalyzer.setSensorToBufferTransformMatrix(matrix);
    }

    private boolean isFlipWH(@NonNull CameraInternal cameraInternal) {
        return this.isOutputImageRotationEnabled() ? this.getRelativeRotation(cameraInternal) % 180 != 0 : false;
    }

    public int getBackpressureStrategy() {
        return ((ImageAnalysisConfig)this.getCurrentConfig()).getBackpressureStrategy(0);
    }

    @Nullable
    @ExperimentalUseCaseApi
    public Executor getBackgroundExecutor() {
        return ((ImageAnalysisConfig)this.getCurrentConfig()).getBackgroundExecutor(null);
    }

    public int getImageQueueDepth() {
        return ((ImageAnalysisConfig)this.getCurrentConfig()).getImageQueueDepth(6);
    }

    public int getOutputImageFormat() {
        return ((ImageAnalysisConfig)this.getCurrentConfig()).getOutputImageFormat(1);
    }

    public boolean isOutputImageRotationEnabled() {
        return ((ImageAnalysisConfig)this.getCurrentConfig()).isOutputImageRotationEnabled(false);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Boolean getOnePixelShiftEnabled() {
        return ((ImageAnalysisConfig)this.getCurrentConfig()).getOnePixelShiftEnabled(DEFAULT_ONE_PIXEL_SHIFT_ENABLED);
    }

    @Override
    @Nullable
    public ResolutionInfo getResolutionInfo() {
        return super.getResolutionInfo();
    }

    @NonNull
    public String toString() {
        return "ImageAnalysis:" + this.getName();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onDetached() {
        this.clearPipeline();
        this.mImageAnalysisAbstractAnalyzer.detach();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public UseCaseConfig<?> getDefaultConfig(boolean applyDefaultConfig, @NonNull UseCaseConfigFactory factory) {
        Config captureConfig = factory.getConfig(UseCaseConfigFactory.CaptureType.IMAGE_ANALYSIS, 1);
        if (applyDefaultConfig) {
            captureConfig = Config.mergeConfigs(captureConfig, DEFAULT_CONFIG.getConfig());
        }
        return captureConfig == null ? null : (UseCaseConfig<?>)this.getUseCaseConfigBuilder(captureConfig).getUseCaseConfig();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onAttached() {
        this.mImageAnalysisAbstractAnalyzer.attach();
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public UseCaseConfig.Builder<?, ?, ?> getUseCaseConfigBuilder(@NonNull Config config) {
        return Builder.fromConfig(config);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected Size onSuggestedResolutionUpdated(@NonNull Size suggestedResolution) {
        ImageAnalysisConfig config = (ImageAnalysisConfig)this.getCurrentConfig();
        SessionConfig.Builder sessionConfigBuilder = this.createPipeline(this.getCameraId(), config, suggestedResolution);
        this.updateSessionConfig(sessionConfigBuilder.build());
        return suggestedResolution;
    }

    private void tryUpdateRelativeRotation() {
        CameraInternal cameraInternal = this.getCamera();
        if (cameraInternal != null) {
            this.mImageAnalysisAbstractAnalyzer.setRelativeRotation(this.getRelativeRotation(cameraInternal));
        }
    }

    public static final class Builder
    implements ImageOutputConfig.Builder<Builder>,
    ThreadConfig.Builder<Builder>,
    UseCaseConfig.Builder<ImageAnalysis, ImageAnalysisConfig, Builder> {
        private final MutableOptionsBundle mMutableConfig;

        public Builder() {
            this(MutableOptionsBundle.create());
        }

        private Builder(MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            Class oldConfigClass = mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(ImageAnalysis.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setTargetClass((Class)ImageAnalysis.class);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        static Builder fromConfig(@NonNull Config configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static Builder fromConfig(@NonNull ImageAnalysisConfig configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @NonNull
        public Builder setBackpressureStrategy(int strategy) {
            this.getMutableConfig().insertOption(ImageAnalysisConfig.OPTION_BACKPRESSURE_STRATEGY, strategy);
            return this;
        }

        @NonNull
        public Builder setImageQueueDepth(int depth) {
            this.getMutableConfig().insertOption(ImageAnalysisConfig.OPTION_IMAGE_QUEUE_DEPTH, depth);
            return this;
        }

        @NonNull
        public Builder setOutputImageFormat(int outputImageFormat) {
            this.getMutableConfig().insertOption(ImageAnalysisConfig.OPTION_OUTPUT_IMAGE_FORMAT, outputImageFormat);
            return this;
        }

        @RequiresApi(value=23)
        @NonNull
        public Builder setOutputImageRotationEnabled(boolean outputImageRotationEnabled) {
            this.getMutableConfig().insertOption(ImageAnalysisConfig.OPTION_OUTPUT_IMAGE_ROTATION_ENABLED, outputImageRotationEnabled);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setOnePixelShiftEnabled(boolean onePixelShiftEnabled) {
            this.getMutableConfig().insertOption(ImageAnalysisConfig.OPTION_ONE_PIXEL_SHIFT_ENABLED, onePixelShiftEnabled);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public ImageAnalysisConfig getUseCaseConfig() {
            return new ImageAnalysisConfig(OptionsBundle.from(this.mMutableConfig));
        }

        @Override
        @NonNull
        public ImageAnalysis build() {
            if (this.getMutableConfig().retrieveOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO, null) != null && this.getMutableConfig().retrieveOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION, null) != null) {
                throw new IllegalArgumentException("Cannot use both setTargetResolution and setTargetAspectRatio on the same config.");
            }
            return new ImageAnalysis(this.getUseCaseConfig());
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setTargetClass(@NonNull Class<ImageAnalysis> targetClass) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(UseCaseConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_TARGET_NAME, targetName);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetAspectRatio(int aspectRatio) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO, aspectRatio);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetRotation(int rotation) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_ROTATION, rotation);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setDefaultResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_DEFAULT_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setMaxResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_MAX_RESOLUTION, resolution);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> resolutions) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_SUPPORTED_RESOLUTIONS, resolutions);
            return this;
        }

        @Override
        @NonNull
        public Builder setBackgroundExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(ThreadConfig.OPTION_BACKGROUND_EXECUTOR, executor);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_DEFAULT_SESSION_CONFIG, sessionConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_DEFAULT_CAPTURE_CONFIG, captureConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_SESSION_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAPTURE_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSurfaceOccupancyPriority(int priority) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, priority);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        public Builder setCameraSelector(@NonNull CameraSelector cameraSelector) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAMERA_SELECTOR, cameraSelector);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setUseCaseEventCallback(@NonNull UseCase.EventCallback useCaseEventCallback) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_USE_CASE_EVENT_CALLBACK, useCaseEventCallback);
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setImageReaderProxyProvider(@NonNull ImageReaderProxyProvider imageReaderProxyProvider) {
            this.getMutableConfig().insertOption(ImageAnalysisConfig.OPTION_IMAGE_READER_PROXY_PROVIDER, imageReaderProxyProvider);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setZslDisabled(boolean disabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_ZSL_DISABLED, disabled);
            return this;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Defaults
    implements ConfigProvider<ImageAnalysisConfig> {
        private static final Size DEFAULT_TARGET_RESOLUTION = new Size(640, 480);
        private static final int DEFAULT_SURFACE_OCCUPANCY_PRIORITY = 1;
        private static final int DEFAULT_ASPECT_RATIO = 0;
        private static final ImageAnalysisConfig DEFAULT_CONFIG;

        @Override
        @NonNull
        public ImageAnalysisConfig getConfig() {
            return DEFAULT_CONFIG;
        }

        static {
            Builder builder = new Builder().setDefaultResolution(DEFAULT_TARGET_RESOLUTION).setSurfaceOccupancyPriority(1).setTargetAspectRatio(0);
            DEFAULT_CONFIG = builder.getUseCaseConfig();
        }
    }

    public static interface Analyzer {
        public void analyze(@NonNull ImageProxy var1);

        @Nullable
        default public Size getDefaultTargetResolution() {
            return null;
        }

        default public int getTargetCoordinateSystem() {
            return 0;
        }

        default public void updateTransform(@Nullable Matrix matrix) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface OutputImageFormat {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface BackpressureStrategy {
    }
}

