/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.core.AutoValue_SurfaceOutput_Event;
import androidx.core.util.Consumer;
import com.google.auto.value.AutoValue;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public interface SurfaceOutput {
    @NonNull
    public Surface getSurface(@NonNull Executor var1, @NonNull Consumer<Event> var2);

    public int getTargets();

    @NonNull
    public Size getSize();

    public int getFormat();

    public int getRotationDegrees();

    public void close();

    public void updateTransformMatrix(@NonNull float[] var1, @NonNull float[] var2);

    public static enum GlTransformOptions {
        USE_SURFACE_TEXTURE_TRANSFORM,
        APPLY_CROP_ROTATE_AND_MIRRORING;

    }

    @AutoValue
    public static abstract class Event {
        public static final int EVENT_REQUEST_CLOSE = 0;

        public abstract int getEventCode();

        @NonNull
        public abstract SurfaceOutput getSurfaceOutput();

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static Event of(int code, @NonNull SurfaceOutput surfaceOutput) {
            return new AutoValue_SurfaceOutput_Event(code, surfaceOutput);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @interface EventCode {
        }
    }
}

