/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.impl.CamcorderProfileProvider;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.Timebase;
import androidx.core.util.Preconditions;
import java.util.Collections;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public interface CameraInfoInternal
extends CameraInfo {
    @Nullable
    public Integer getLensFacing();

    @NonNull
    public String getCameraId();

    public void addSessionCaptureCallback(@NonNull Executor var1, @NonNull CameraCaptureCallback var2);

    public void removeSessionCaptureCallback(@NonNull CameraCaptureCallback var1);

    @NonNull
    public Quirks getCameraQuirks();

    @NonNull
    public CamcorderProfileProvider getCamcorderProfileProvider();

    @NonNull
    public Timebase getTimebase();

    @Override
    @NonNull
    default public CameraSelector getCameraSelector() {
        return new CameraSelector.Builder().addCameraFilter(cameraInfos -> {
            String cameraId = this.getCameraId();
            for (CameraInfo cameraInfo : cameraInfos) {
                Preconditions.checkArgument((boolean)(cameraInfo instanceof CameraInfoInternal));
                CameraInfoInternal cameraInfoInternal = (CameraInfoInternal)cameraInfo;
                if (!cameraInfoInternal.getCameraId().equals(cameraId)) continue;
                return Collections.singletonList(cameraInfo);
            }
            throw new IllegalStateException("Unable to find camera with id " + cameraId + " from list of available cameras.");
        }).build();
    }
}

