/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraControl;
import androidx.camera.core.CameraEffect;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.core.Preview;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.UseCase;
import androidx.camera.core.ViewPort;
import androidx.camera.core.impl.AttachedSurfaceInfo;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraConfigs;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CameraDeviceSurfaceManager;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.ViewPorts;
import androidx.camera.core.processing.SurfaceProcessorWithExecutor;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@RequiresApi(value=21)
public final class CameraUseCaseAdapter
implements Camera {
    @NonNull
    private CameraInternal mCameraInternal;
    private final LinkedHashSet<CameraInternal> mCameraInternals;
    private final CameraDeviceSurfaceManager mCameraDeviceSurfaceManager;
    private final UseCaseConfigFactory mUseCaseConfigFactory;
    private static final String TAG = "CameraUseCaseAdapter";
    private final CameraId mId;
    @GuardedBy(value="mLock")
    private final List<UseCase> mUseCases = new ArrayList<UseCase>();
    @GuardedBy(value="mLock")
    @Nullable
    private ViewPort mViewPort;
    @GuardedBy(value="mLock")
    @NonNull
    private List<CameraEffect> mEffects = Collections.emptyList();
    @GuardedBy(value="mLock")
    @NonNull
    private CameraConfig mCameraConfig = CameraConfigs.emptyConfig();
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private boolean mAttached = true;
    @GuardedBy(value="mLock")
    private Config mInteropConfig = null;
    @GuardedBy(value="mLock")
    private List<UseCase> mExtraUseCases = new ArrayList<UseCase>();

    public CameraUseCaseAdapter(@NonNull LinkedHashSet<CameraInternal> cameras, @NonNull CameraDeviceSurfaceManager cameraDeviceSurfaceManager, @NonNull UseCaseConfigFactory useCaseConfigFactory) {
        this.mCameraInternal = (CameraInternal)cameras.iterator().next();
        this.mCameraInternals = new LinkedHashSet<CameraInternal>(cameras);
        this.mId = new CameraId(this.mCameraInternals);
        this.mCameraDeviceSurfaceManager = cameraDeviceSurfaceManager;
        this.mUseCaseConfigFactory = useCaseConfigFactory;
    }

    @NonNull
    public static CameraId generateCameraId(@NonNull LinkedHashSet<CameraInternal> cameras) {
        return new CameraId(cameras);
    }

    @NonNull
    public CameraId getCameraId() {
        return this.mId;
    }

    public boolean isEquivalent(@NonNull CameraUseCaseAdapter cameraUseCaseAdapter) {
        return this.mId.equals(cameraUseCaseAdapter.getCameraId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewPort(@Nullable ViewPort viewPort) {
        Object object = this.mLock;
        synchronized (object) {
            this.mViewPort = viewPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEffects(@Nullable List<CameraEffect> effects) {
        Object object = this.mLock;
        synchronized (object) {
            this.mEffects = effects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUseCases(@NonNull Collection<UseCase> useCases) throws CameraException {
        Object object = this.mLock;
        synchronized (object) {
            Map<UseCase, Size> suggestedResolutionsMap;
            ArrayList<UseCase> newUseCases = new ArrayList<UseCase>();
            for (UseCase useCase : useCases) {
                if (this.mUseCases.contains(useCase)) {
                    Logger.d(TAG, "Attempting to attach already attached UseCase");
                    continue;
                }
                newUseCases.add(useCase);
            }
            ArrayList<UseCase> allUseCases = new ArrayList<UseCase>(this.mUseCases);
            List<Object> requiredExtraUseCases = Collections.emptyList();
            List<UseCase> removedExtraUseCases = Collections.emptyList();
            if (this.isCoexistingPreviewImageCaptureRequired()) {
                allUseCases.removeAll(this.mExtraUseCases);
                allUseCases.addAll(newUseCases);
                requiredExtraUseCases = this.calculateRequiredExtraUseCases(allUseCases, new ArrayList<UseCase>(this.mExtraUseCases));
                ArrayList addedExtraUseCases = new ArrayList(requiredExtraUseCases);
                addedExtraUseCases.removeAll(this.mExtraUseCases);
                newUseCases.addAll(addedExtraUseCases);
                removedExtraUseCases = new ArrayList<UseCase>(this.mExtraUseCases);
                removedExtraUseCases.removeAll(requiredExtraUseCases);
            }
            Map<UseCase, ConfigPair> configs = this.getConfigs(newUseCases, this.mCameraConfig.getUseCaseConfigFactory(), this.mUseCaseConfigFactory);
            try {
                ArrayList<UseCase> boundUseCases = new ArrayList<UseCase>(this.mUseCases);
                boundUseCases.removeAll(removedExtraUseCases);
                suggestedResolutionsMap = this.calculateSuggestedResolutions(this.mCameraInternal.getCameraInfoInternal(), newUseCases, boundUseCases, configs);
            }
            catch (IllegalArgumentException e) {
                throw new CameraException(e.getMessage());
            }
            this.updateViewPort(suggestedResolutionsMap, useCases);
            CameraUseCaseAdapter.updateEffects(this.mEffects, useCases);
            this.mExtraUseCases = requiredExtraUseCases;
            this.detachUnnecessaryUseCases(removedExtraUseCases);
            for (UseCase useCase : newUseCases) {
                ConfigPair configPair = configs.get(useCase);
                useCase.onAttach(this.mCameraInternal, configPair.mExtendedConfig, configPair.mCameraConfig);
                useCase.updateSuggestedResolution((Size)Preconditions.checkNotNull((Object)suggestedResolutionsMap.get(useCase)));
            }
            this.mUseCases.addAll(newUseCases);
            if (this.mAttached) {
                this.mCameraInternal.attachUseCases(newUseCases);
            }
            for (UseCase useCase : newUseCases) {
                useCase.notifyState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUseCases(@NonNull Collection<UseCase> useCases) {
        Object object = this.mLock;
        synchronized (object) {
            this.detachUnnecessaryUseCases(new ArrayList<UseCase>(useCases));
            if (this.isCoexistingPreviewImageCaptureRequired()) {
                this.mExtraUseCases.removeAll(useCases);
                try {
                    this.addUseCases(Collections.emptyList());
                }
                catch (CameraException e) {
                    throw new IllegalArgumentException("Failed to add extra fake Preview or ImageCapture use case!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<UseCase> getUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayList<UseCase>(this.mUseCases);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAttached) {
                this.mCameraInternal.attachUseCases(this.mUseCases);
                this.restoreInteropConfig();
                for (UseCase useCase : this.mUseCases) {
                    useCase.notifyState();
                }
                this.mAttached = true;
            }
        }
    }

    public void setActiveResumingMode(boolean enabled) {
        this.mCameraInternal.setActiveResumingMode(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAttached) {
                this.mCameraInternal.detachUseCases(new ArrayList<UseCase>(this.mUseCases));
                this.cacheInteropConfig();
                this.mAttached = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreInteropConfig() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInteropConfig != null) {
                this.mCameraInternal.getCameraControlInternal().addInteropConfig(this.mInteropConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheInteropConfig() {
        Object object = this.mLock;
        synchronized (object) {
            CameraControlInternal cameraControlInternal = this.mCameraInternal.getCameraControlInternal();
            this.mInteropConfig = cameraControlInternal.getInteropConfig();
            cameraControlInternal.clearInteropConfig();
        }
    }

    private Map<UseCase, Size> calculateSuggestedResolutions(@NonNull CameraInfoInternal cameraInfoInternal, @NonNull List<UseCase> newUseCases, @NonNull List<UseCase> currentUseCases, @NonNull Map<UseCase, ConfigPair> configPairMap) {
        ArrayList<AttachedSurfaceInfo> existingSurfaces = new ArrayList<AttachedSurfaceInfo>();
        String cameraId = cameraInfoInternal.getCameraId();
        HashMap<UseCase, Size> suggestedResolutions = new HashMap<UseCase, Size>();
        for (UseCase useCase : currentUseCases) {
            SurfaceConfig surfaceConfig = this.mCameraDeviceSurfaceManager.transformSurfaceConfig(cameraId, useCase.getImageFormat(), useCase.getAttachedSurfaceResolution());
            existingSurfaces.add(AttachedSurfaceInfo.create(surfaceConfig, useCase.getImageFormat(), useCase.getAttachedSurfaceResolution(), useCase.getCurrentConfig().getTargetFramerate(null)));
            suggestedResolutions.put(useCase, useCase.getAttachedSurfaceResolution());
        }
        if (!newUseCases.isEmpty()) {
            HashMap configToUseCaseMap = new HashMap();
            for (UseCase useCase : newUseCases) {
                ConfigPair configPair = configPairMap.get(useCase);
                UseCaseConfig<?> combinedUseCaseConfig = useCase.mergeConfigs(cameraInfoInternal, configPair.mExtendedConfig, configPair.mCameraConfig);
                configToUseCaseMap.put(combinedUseCaseConfig, useCase);
            }
            Map<UseCaseConfig<?>, Size> map = this.mCameraDeviceSurfaceManager.getSuggestedResolutions(cameraId, existingSurfaces, new ArrayList(configToUseCaseMap.keySet()));
            for (Map.Entry entry : configToUseCaseMap.entrySet()) {
                suggestedResolutions.put((UseCase)entry.getValue(), map.get(entry.getKey()));
            }
        }
        return suggestedResolutions;
    }

    @VisibleForTesting
    static void updateEffects(@NonNull List<CameraEffect> effects, @NonNull Collection<UseCase> useCases) {
        HashMap<Integer, CameraEffect> effectsByTargets = new HashMap<Integer, CameraEffect>();
        for (CameraEffect effect : effects) {
            effectsByTargets.put(effect.getTargets(), effect);
        }
        for (UseCase useCase : useCases) {
            if (!(useCase instanceof Preview)) continue;
            Preview preview = (Preview)useCase;
            CameraEffect effect = (CameraEffect)effectsByTargets.get(1);
            if (effect == null) {
                preview.setProcessor(null);
                continue;
            }
            preview.setProcessor(new SurfaceProcessorWithExecutor(Objects.requireNonNull(effect.getSurfaceProcessor()), effect.getProcessorExecutor()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateViewPort(@NonNull Map<UseCase, Size> suggestedResolutionsMap, @NonNull Collection<UseCase> useCases) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mViewPort != null) {
                boolean isFrontCamera;
                Integer lensFacing = this.mCameraInternal.getCameraInfoInternal().getLensFacing();
                if (lensFacing == null) {
                    Logger.w(TAG, "The lens facing is null, probably an external.");
                    isFrontCamera = true;
                } else {
                    isFrontCamera = lensFacing == 0;
                }
                Map<UseCase, Rect> cropRectMap = ViewPorts.calculateViewPortRects(this.mCameraInternal.getCameraControlInternal().getSensorRect(), isFrontCamera, this.mViewPort.getAspectRatio(), this.mCameraInternal.getCameraInfoInternal().getSensorRotationDegrees(this.mViewPort.getRotation()), this.mViewPort.getScaleType(), this.mViewPort.getLayoutDirection(), suggestedResolutionsMap);
                for (UseCase useCase : useCases) {
                    useCase.setViewPortCropRect((Rect)Preconditions.checkNotNull((Object)cropRectMap.get(useCase)));
                    useCase.setSensorToBufferTransformMatrix(CameraUseCaseAdapter.calculateSensorToBufferTransformMatrix(this.mCameraInternal.getCameraControlInternal().getSensorRect(), suggestedResolutionsMap.get(useCase)));
                }
            }
        }
    }

    @NonNull
    private static Matrix calculateSensorToBufferTransformMatrix(@NonNull Rect fullSensorRect, @NonNull Size useCaseSize) {
        Preconditions.checkArgument((fullSensorRect.width() > 0 && fullSensorRect.height() > 0 ? 1 : 0) != 0, (Object)"Cannot compute viewport crop rects zero sized sensor rect.");
        RectF fullSensorRectF = new RectF(fullSensorRect);
        Matrix sensorToUseCaseTransformation = new Matrix();
        RectF srcRect = new RectF(0.0f, 0.0f, (float)useCaseSize.getWidth(), (float)useCaseSize.getHeight());
        sensorToUseCaseTransformation.setRectToRect(srcRect, fullSensorRectF, Matrix.ScaleToFit.CENTER);
        sensorToUseCaseTransformation.invert(sensorToUseCaseTransformation);
        return sensorToUseCaseTransformation;
    }

    private Map<UseCase, ConfigPair> getConfigs(List<UseCase> useCases, UseCaseConfigFactory extendedFactory, UseCaseConfigFactory cameraFactory) {
        HashMap<UseCase, ConfigPair> configs = new HashMap<UseCase, ConfigPair>();
        for (UseCase useCase : useCases) {
            configs.put(useCase, new ConfigPair(useCase.getDefaultConfig(false, extendedFactory), useCase.getDefaultConfig(true, cameraFactory)));
        }
        return configs;
    }

    @Override
    @NonNull
    public CameraControl getCameraControl() {
        return this.mCameraInternal.getCameraControlInternal();
    }

    @Override
    @NonNull
    public CameraInfo getCameraInfo() {
        return this.mCameraInternal.getCameraInfoInternal();
    }

    @Override
    @NonNull
    public LinkedHashSet<CameraInternal> getCameraInternals() {
        return this.mCameraInternals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public CameraConfig getExtendedConfig() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCameraConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExtendedConfig(@Nullable CameraConfig cameraConfig) {
        Object object = this.mLock;
        synchronized (object) {
            if (cameraConfig == null) {
                cameraConfig = CameraConfigs.emptyConfig();
            }
            if (!this.mUseCases.isEmpty() && !this.mCameraConfig.getCompatibilityId().equals(cameraConfig.getCompatibilityId())) {
                throw new IllegalStateException("Need to unbind all use cases before binding with extension enabled");
            }
            this.mCameraConfig = cameraConfig;
            this.mCameraInternal.setExtendedConfig(this.mCameraConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUseCasesCombinationSupported(UseCase ... useCases) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                Map<UseCase, ConfigPair> configs = this.getConfigs(Arrays.asList(useCases), this.mCameraConfig.getUseCaseConfigFactory(), this.mUseCaseConfigFactory);
                this.calculateSuggestedResolutions(this.mCameraInternal.getCameraInfoInternal(), Arrays.asList(useCases), Collections.emptyList(), configs);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            return true;
        }
    }

    @NonNull
    private List<UseCase> calculateRequiredExtraUseCases(@NonNull List<UseCase> boundUseCases, @NonNull List<UseCase> extraUseCases) {
        ArrayList<UseCase> requiredExtraUseCases = new ArrayList<UseCase>(extraUseCases);
        boolean isExtraPreviewRequired = this.isExtraPreviewRequired(boundUseCases);
        boolean isExtraImageCaptureRequired = this.isExtraImageCaptureRequired(boundUseCases);
        UseCase existingExtraPreview = null;
        UseCase existingExtraImageCapture = null;
        for (UseCase useCase : extraUseCases) {
            if (this.isPreview(useCase)) {
                existingExtraPreview = useCase;
                continue;
            }
            if (!this.isImageCapture(useCase)) continue;
            existingExtraImageCapture = useCase;
        }
        if (isExtraPreviewRequired && existingExtraPreview == null) {
            requiredExtraUseCases.add(this.createExtraPreview());
        } else if (!isExtraPreviewRequired && existingExtraPreview != null) {
            requiredExtraUseCases.remove(existingExtraPreview);
        }
        if (isExtraImageCaptureRequired && existingExtraImageCapture == null) {
            requiredExtraUseCases.add(this.createExtraImageCapture());
        } else if (!isExtraImageCaptureRequired && existingExtraImageCapture != null) {
            requiredExtraUseCases.remove(existingExtraImageCapture);
        }
        return requiredExtraUseCases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detachUnnecessaryUseCases(@NonNull List<UseCase> unnecessaryUseCases) {
        Object object = this.mLock;
        synchronized (object) {
            if (!unnecessaryUseCases.isEmpty()) {
                this.mCameraInternal.detachUseCases(unnecessaryUseCases);
                for (UseCase useCase : unnecessaryUseCases) {
                    if (this.mUseCases.contains(useCase)) {
                        useCase.onDetach(this.mCameraInternal);
                        continue;
                    }
                    Logger.e(TAG, "Attempting to detach non-attached UseCase: " + useCase);
                }
                this.mUseCases.removeAll(unnecessaryUseCases);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCoexistingPreviewImageCaptureRequired() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCameraConfig.getUseCaseCombinationRequiredRule() == 1;
        }
    }

    private boolean isExtraPreviewRequired(@NonNull List<UseCase> useCases) {
        boolean hasPreview = false;
        boolean hasImageCapture = false;
        for (UseCase useCase : useCases) {
            if (this.isPreview(useCase)) {
                hasPreview = true;
                continue;
            }
            if (!this.isImageCapture(useCase)) continue;
            hasImageCapture = true;
        }
        return hasImageCapture && !hasPreview;
    }

    private boolean isExtraImageCaptureRequired(@NonNull List<UseCase> useCases) {
        boolean hasPreview = false;
        boolean hasImageCapture = false;
        for (UseCase useCase : useCases) {
            if (this.isPreview(useCase)) {
                hasPreview = true;
                continue;
            }
            if (!this.isImageCapture(useCase)) continue;
            hasImageCapture = true;
        }
        return hasPreview && !hasImageCapture;
    }

    private boolean isPreview(UseCase useCase) {
        return useCase instanceof Preview;
    }

    private boolean isImageCapture(UseCase useCase) {
        return useCase instanceof ImageCapture;
    }

    private Preview createExtraPreview() {
        Preview preview = new Preview.Builder().setTargetName("Preview-Extra").build();
        preview.setSurfaceProvider(surfaceRequest -> {
            SurfaceTexture surfaceTexture = new SurfaceTexture(0);
            surfaceTexture.setDefaultBufferSize(surfaceRequest.getResolution().getWidth(), surfaceRequest.getResolution().getHeight());
            surfaceTexture.detachFromGLContext();
            Surface surface = new Surface(surfaceTexture);
            surfaceRequest.provideSurface(surface, CameraXExecutors.directExecutor(), (Consumer<SurfaceRequest.Result>)((Consumer)surfaceResponse -> {
                surface.release();
                surfaceTexture.release();
            }));
        });
        return preview;
    }

    private ImageCapture createExtraImageCapture() {
        return new ImageCapture.Builder().setTargetName("ImageCapture-Extra").build();
    }

    public static final class CameraException
    extends Exception {
        public CameraException() {
        }

        public CameraException(@NonNull String message) {
            super(message);
        }

        public CameraException(@NonNull Throwable cause) {
            super(cause);
        }
    }

    public static final class CameraId {
        private final List<String> mIds = new ArrayList<String>();

        CameraId(LinkedHashSet<CameraInternal> cameraInternals) {
            for (CameraInternal cameraInternal : cameraInternals) {
                this.mIds.add(cameraInternal.getCameraInfoInternal().getCameraId());
            }
        }

        public boolean equals(Object cameraId) {
            if (cameraId instanceof CameraId) {
                return this.mIds.equals(((CameraId)cameraId).mIds);
            }
            return false;
        }

        public int hashCode() {
            return 53 * this.mIds.hashCode();
        }
    }

    private static class ConfigPair {
        UseCaseConfig<?> mExtendedConfig;
        UseCaseConfig<?> mCameraConfig;

        ConfigPair(UseCaseConfig<?> extendedConfig, UseCaseConfig<?> cameraConfig) {
            this.mExtendedConfig = extendedConfig;
            this.mCameraConfig = cameraConfig;
        }
    }
}

