/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.SurfaceOutput;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.processing.SurfaceOutputImpl;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;

@RequiresApi(api=21)
public class SettableSurface
extends DeferrableSurface {
    private final ListenableFuture<Surface> mSurfaceFuture;
    CallbackToFutureAdapter.Completer<Surface> mCompleter;
    private final Matrix mSensorToBufferTransform;
    private final boolean mHasEmbeddedTransform;
    private final Rect mCropRect;
    private final boolean mMirroring;
    private final int mTargets;
    private int mRotationDegrees;
    @Nullable
    private SurfaceOutputImpl mConsumerToNotify;
    private boolean mHasProvider = false;
    private boolean mHasConsumer = false;
    @Nullable
    private SurfaceRequest mProviderSurfaceRequest;

    public SettableSurface(int targets, @NonNull Size size, int format, @NonNull Matrix sensorToBufferTransform, boolean hasEmbeddedTransform, @NonNull Rect cropRect, int rotationDegrees, boolean mirroring) {
        super(size, format);
        this.mTargets = targets;
        this.mSensorToBufferTransform = sensorToBufferTransform;
        this.mHasEmbeddedTransform = hasEmbeddedTransform;
        this.mCropRect = cropRect;
        this.mRotationDegrees = rotationDegrees;
        this.mMirroring = mirroring;
        this.mSurfaceFuture = CallbackToFutureAdapter.getFuture(completer -> {
            this.mCompleter = completer;
            return "SettableFuture size: " + size + " hashCode: " + this.hashCode();
        });
    }

    @Override
    @NonNull
    protected ListenableFuture<Surface> provideSurface() {
        return this.mSurfaceFuture;
    }

    @MainThread
    public void setProvider(@NonNull ListenableFuture<Surface> surfaceFuture) {
        Threads.checkMainThread();
        Preconditions.checkState((!this.mHasProvider ? 1 : 0) != 0, (String)"Provider can only be linked once.");
        this.mHasProvider = true;
        Futures.propagate(surfaceFuture, this.mCompleter);
    }

    @MainThread
    public void setProvider(@NonNull DeferrableSurface provider) throws DeferrableSurface.SurfaceClosedException {
        Threads.checkMainThread();
        this.setProvider(provider.getSurface());
        provider.incrementUseCount();
        this.getTerminationFuture().addListener(() -> {
            provider.decrementUseCount();
            provider.close();
        }, CameraXExecutors.directExecutor());
    }

    @MainThread
    @NonNull
    public SurfaceRequest createSurfaceRequest(@NonNull CameraInternal cameraInternal) {
        return this.createSurfaceRequest(cameraInternal, null);
    }

    @MainThread
    @NonNull
    public SurfaceRequest createSurfaceRequest(@NonNull CameraInternal cameraInternal, @Nullable Range<Integer> expectedFpsRange) {
        Threads.checkMainThread();
        SurfaceRequest surfaceRequest = new SurfaceRequest(this.getSize(), cameraInternal, true, expectedFpsRange);
        try {
            this.setProvider(surfaceRequest.getDeferrableSurface());
        }
        catch (DeferrableSurface.SurfaceClosedException e) {
            throw new AssertionError("Surface is somehow already closed", e);
        }
        this.mProviderSurfaceRequest = surfaceRequest;
        this.notifyTransformationInfoUpdate();
        return surfaceRequest;
    }

    @MainThread
    @NonNull
    public ListenableFuture<SurfaceOutput> createSurfaceOutputFuture(@NonNull SurfaceOutput.GlTransformOptions glTransformOptions, @NonNull Size resolution, @NonNull Rect cropRect, int rotationDegrees, boolean mirroring) {
        Threads.checkMainThread();
        Preconditions.checkState((!this.mHasConsumer ? 1 : 0) != 0, (String)"Consumer can only be linked once.");
        this.mHasConsumer = true;
        return Futures.transformAsync(this.getSurface(), surface -> {
            Preconditions.checkNotNull((Object)surface);
            try {
                this.incrementUseCount();
            }
            catch (DeferrableSurface.SurfaceClosedException e) {
                return Futures.immediateFailedFuture(e);
            }
            SurfaceOutputImpl surfaceOutputImpl = new SurfaceOutputImpl((Surface)surface, this.getTargets(), this.getFormat(), this.getSize(), glTransformOptions, resolution, cropRect, rotationDegrees, mirroring);
            surfaceOutputImpl.getCloseFuture().addListener(this::decrementUseCount, CameraXExecutors.directExecutor());
            this.mConsumerToNotify = surfaceOutputImpl;
            return Futures.immediateFuture(surfaceOutputImpl);
        }, CameraXExecutors.mainThreadExecutor());
    }

    @Override
    public final void close() {
        super.close();
        CameraXExecutors.mainThreadExecutor().execute(() -> {
            if (this.mConsumerToNotify != null) {
                this.mConsumerToNotify.requestClose();
                this.mConsumerToNotify = null;
            }
        });
    }

    public int getTargets() {
        return this.mTargets;
    }

    @NonNull
    public Size getSize() {
        return this.getPrescribedSize();
    }

    public int getFormat() {
        return this.getPrescribedStreamFormat();
    }

    @NonNull
    public Matrix getSensorToBufferTransform() {
        return this.mSensorToBufferTransform;
    }

    public boolean hasEmbeddedTransform() {
        return this.mHasEmbeddedTransform;
    }

    @NonNull
    public Rect getCropRect() {
        return this.mCropRect;
    }

    public int getRotationDegrees() {
        return this.mRotationDegrees;
    }

    @MainThread
    public void setRotationDegrees(int rotationDegrees) {
        Threads.checkMainThread();
        if (this.mRotationDegrees == rotationDegrees) {
            return;
        }
        this.mRotationDegrees = rotationDegrees;
        this.notifyTransformationInfoUpdate();
    }

    @MainThread
    private void notifyTransformationInfoUpdate() {
        if (this.mProviderSurfaceRequest != null) {
            this.mProviderSurfaceRequest.updateTransformationInfo(SurfaceRequest.TransformationInfo.of(this.mCropRect, this.mRotationDegrees, -1));
        }
    }

    public boolean getMirroring() {
        return this.mMirroring;
    }
}

