/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.util.Size;
import android.view.Surface;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.MetadataImageReader;
import androidx.camera.core.SafeCloseImageReaderProxy;
import androidx.camera.core.imagecapture.AutoValue_CaptureNode_In;
import androidx.camera.core.imagecapture.AutoValue_CaptureNode_Out;
import androidx.camera.core.imagecapture.ProcessingRequest;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.processing.Edge;
import androidx.camera.core.processing.Node;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@RequiresApi(api=21)
class CaptureNode
implements Node<In, Out> {
    @VisibleForTesting
    static final int MAX_IMAGES = 4;
    @NonNull
    private final Set<Integer> mPendingStageIds = new HashSet<Integer>();
    private final Set<ImageProxy> mPendingImages = new HashSet<ImageProxy>();
    private ProcessingRequest mCurrentRequest = null;
    SafeCloseImageReaderProxy mSafeCloseImageReaderProxy;
    private Out mOutputEdge;
    private In mInputEdge;

    CaptureNode() {
    }

    @Override
    @NonNull
    public Out transform(@NonNull In inputEdge) {
        this.mInputEdge = inputEdge;
        Size size = inputEdge.getSize();
        int format = inputEdge.getFormat();
        MetadataImageReader metadataImageReader = new MetadataImageReader(size.getWidth(), size.getHeight(), format, 4);
        this.mSafeCloseImageReaderProxy = new SafeCloseImageReaderProxy(metadataImageReader);
        inputEdge.setCameraCaptureCallback(metadataImageReader.getCameraCaptureCallback());
        inputEdge.setSurface(Objects.requireNonNull(metadataImageReader.getSurface()));
        metadataImageReader.setOnImageAvailableListener(imageReader -> this.onImageProxyAvailable(Objects.requireNonNull(imageReader.acquireNextImage())), CameraXExecutors.mainThreadExecutor());
        inputEdge.getRequestEdge().setListener((Consumer<ProcessingRequest>)((Consumer)this::onRequestAvailable));
        this.mOutputEdge = Out.of(inputEdge.getFormat());
        return this.mOutputEdge;
    }

    @VisibleForTesting
    @MainThread
    void onImageProxyAvailable(@NonNull ImageProxy imageProxy) {
        Threads.checkMainThread();
        if (this.mCurrentRequest == null) {
            this.mPendingImages.add(imageProxy);
        } else {
            this.matchAndPropagateImage(imageProxy);
        }
    }

    private void matchAndPropagateImage(@NonNull ImageProxy imageProxy) {
        int stageId = (Integer)Objects.requireNonNull(imageProxy.getImageInfo().getTagBundle().getTag(this.mCurrentRequest.getTagBundleKey()));
        Preconditions.checkState((boolean)this.mPendingStageIds.contains(stageId), (String)("Received an unexpected stage id" + stageId));
        this.mPendingStageIds.remove(stageId);
        if (this.mPendingStageIds.isEmpty()) {
            this.mCurrentRequest.onImageCaptured();
            this.mCurrentRequest = null;
        }
        this.mOutputEdge.getImageEdge().accept(imageProxy);
    }

    @VisibleForTesting
    @MainThread
    void onRequestAvailable(@NonNull ProcessingRequest request) {
        Threads.checkMainThread();
        Preconditions.checkState((this.getCapacity() > 0 ? 1 : 0) != 0, (String)"Too many acquire images. Close image to be able to process next.");
        Preconditions.checkState((this.mCurrentRequest == null || this.mPendingStageIds.isEmpty() ? 1 : 0) != 0, (String)"The previous request is not complete");
        this.mCurrentRequest = request;
        this.mPendingStageIds.addAll(request.getStageIds());
        this.mOutputEdge.getRequestEdge().accept(request);
        for (ImageProxy imageProxy : this.mPendingImages) {
            this.matchAndPropagateImage(imageProxy);
        }
        this.mPendingImages.clear();
    }

    @Override
    @MainThread
    public void release() {
        Threads.checkMainThread();
        if (this.mSafeCloseImageReaderProxy != null) {
            this.mSafeCloseImageReaderProxy.safeClose();
        }
        if (this.mInputEdge != null) {
            this.mInputEdge.closeSurface();
        }
    }

    @VisibleForTesting
    @NonNull
    In getInputEdge() {
        return this.mInputEdge;
    }

    @MainThread
    public int getCapacity() {
        Threads.checkMainThread();
        Preconditions.checkState((this.mSafeCloseImageReaderProxy != null ? 1 : 0) != 0, (String)"The ImageReader is not initialized.");
        return this.mSafeCloseImageReaderProxy.getCapacity();
    }

    @MainThread
    public void setOnImageCloseListener(ForwardingImageProxy.OnImageCloseListener listener) {
        Threads.checkMainThread();
        Preconditions.checkState((this.mSafeCloseImageReaderProxy != null ? 1 : 0) != 0, (String)"The ImageReader is not initialized.");
        this.mSafeCloseImageReaderProxy.setOnImageCloseListener(listener);
    }

    @AutoValue
    static abstract class Out {
        Out() {
        }

        abstract Edge<ImageProxy> getImageEdge();

        abstract Edge<ProcessingRequest> getRequestEdge();

        abstract int getFormat();

        static Out of(int format) {
            return new AutoValue_CaptureNode_Out(new Edge<ImageProxy>(), new Edge<ProcessingRequest>(), format);
        }
    }

    @AutoValue
    static abstract class In {
        private CameraCaptureCallback mCameraCaptureCallback;
        private DeferrableSurface mSurface;

        In() {
        }

        abstract Size getSize();

        abstract int getFormat();

        @NonNull
        abstract Edge<ProcessingRequest> getRequestEdge();

        @NonNull
        DeferrableSurface getSurface() {
            return this.mSurface;
        }

        void setSurface(@NonNull Surface surface) {
            Preconditions.checkState((this.mSurface == null ? 1 : 0) != 0, (String)"The surface is already set.");
            this.mSurface = new ImmediateSurface(surface);
        }

        void closeSurface() {
            this.mSurface.close();
        }

        CameraCaptureCallback getCameraCaptureCallback() {
            return this.mCameraCaptureCallback;
        }

        void setCameraCaptureCallback(@NonNull CameraCaptureCallback cameraCaptureCallback) {
            this.mCameraCaptureCallback = cameraCaptureCallback;
        }

        @NonNull
        static In of(Size size, int format) {
            return new AutoValue_CaptureNode_In(size, format, new Edge<ProcessingRequest>());
        }
    }
}

