/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.imagecapture.AutoValue_Image2JpegBytes_In;
import androidx.camera.core.impl.utils.Exif;
import androidx.camera.core.impl.utils.ExifData;
import androidx.camera.core.impl.utils.ExifOutputStream;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.internal.ByteBufferOutputStream;
import androidx.camera.core.internal.utils.ImageUtil;
import androidx.camera.core.processing.Operation;
import androidx.camera.core.processing.Packet;
import com.google.auto.value.AutoValue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;

@RequiresApi(api=21)
final class Image2JpegBytes
implements Operation<In, Packet<byte[]>> {
    Image2JpegBytes() {
    }

    @Override
    @NonNull
    public Packet<byte[]> apply(@NonNull In input) throws ImageCaptureException {
        try {
            int imageFormat = input.getPacket().getFormat();
            switch (imageFormat) {
                case 256: {
                    Packet<byte[]> packet = this.processJpegImage(input);
                    return packet;
                }
                case 35: {
                    Packet<byte[]> packet = this.processYuvImage(input);
                    return packet;
                }
            }
            throw new IllegalArgumentException("Unexpected format: " + imageFormat);
        }
        finally {
            input.getPacket().getData().close();
        }
    }

    private Packet<byte[]> processJpegImage(@NonNull In input) {
        Packet<ImageProxy> packet = input.getPacket();
        return Packet.of(ImageUtil.jpegImageToJpegByteArray(packet.getData()), Objects.requireNonNull(packet.getExif()), 256, packet.getSize(), packet.getCropRect(), packet.getRotationDegrees(), packet.getSensorToBufferTransform(), packet.getCameraCaptureResult());
    }

    private Packet<byte[]> processYuvImage(@NonNull In input) throws ImageCaptureException {
        Packet<ImageProxy> packet = input.getPacket();
        ImageProxy image = packet.getData();
        Rect cropRect = packet.getCropRect();
        byte[] yuvBytes = ImageUtil.yuv_420_888toNv21(image);
        YuvImage yuvImage = new YuvImage(yuvBytes, 17, image.getWidth(), image.getHeight(), null);
        ByteBuffer buffer = ByteBuffer.allocateDirect(cropRect.width() * cropRect.height() * 2);
        ExifOutputStream outputStream = new ExifOutputStream(new ByteBufferOutputStream(buffer), ExifData.create(image, packet.getRotationDegrees()));
        yuvImage.compressToJpeg(cropRect, input.getJpegQuality(), (OutputStream)outputStream);
        byte[] jpegBytes = Image2JpegBytes.byteBufferToByteArray(buffer);
        return Packet.of(jpegBytes, Image2JpegBytes.extractExif(jpegBytes), 256, new Size(cropRect.width(), cropRect.height()), new Rect(0, 0, cropRect.width(), cropRect.height()), packet.getRotationDegrees(), TransformUtils.updateSensorToBufferTransform(packet.getSensorToBufferTransform(), cropRect), packet.getCameraCaptureResult());
    }

    private static byte[] byteBufferToByteArray(@NonNull ByteBuffer buffer) {
        int jpegSize = buffer.position();
        byte[] bytes = new byte[jpegSize];
        buffer.rewind();
        buffer.get(bytes, 0, jpegSize);
        return bytes;
    }

    private static Exif extractExif(@NonNull byte[] jpegBytes) throws ImageCaptureException {
        try {
            return Exif.createFromInputStream(new ByteArrayInputStream(jpegBytes));
        }
        catch (IOException e) {
            throw new ImageCaptureException(0, "Failed to extract Exif from YUV-generated JPEG", e);
        }
    }

    @AutoValue
    static abstract class In {
        In() {
        }

        abstract Packet<ImageProxy> getPacket();

        abstract int getJpegQuality();

        @NonNull
        static In of(@NonNull Packet<ImageProxy> imagePacket, int jpegQuality) {
            return new AutoValue_Image2JpegBytes_In(imagePacket, jpegQuality);
        }
    }
}

