/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Size;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.imagecapture.ImagePipeline;
import androidx.camera.core.imagecapture.ProcessingNode;
import androidx.camera.core.imagecapture.ProcessingRequest;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.utils.Exif;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.internal.CameraCaptureResultImageInfo;
import androidx.camera.core.processing.Operation;
import androidx.camera.core.processing.Packet;
import androidx.core.util.Preconditions;
import java.io.IOException;

@RequiresApi(api=21)
final class ProcessingInput2Packet
implements Operation<ProcessingNode.InputPacket, Packet<ImageProxy>> {
    ProcessingInput2Packet() {
    }

    @Override
    @NonNull
    public Packet<ImageProxy> apply(@NonNull ProcessingNode.InputPacket inputPacket) throws ImageCaptureException {
        ImageProxy image = inputPacket.getImageProxy();
        ProcessingRequest request = inputPacket.getProcessingRequest();
        Exif exif = null;
        if (image.getFormat() == 256) {
            try {
                exif = Exif.createFromImageProxy(image);
                image.getPlanes()[0].getBuffer().rewind();
            }
            catch (IOException e) {
                throw new ImageCaptureException(1, "Failed to extract EXIF data.", e);
            }
        }
        CameraCaptureResult cameraCaptureResult = ((CameraCaptureResultImageInfo)image.getImageInfo()).getCameraCaptureResult();
        Rect cropRect = request.getCropRect();
        Matrix sensorToBuffer = request.getSensorToBufferTransform();
        int rotationDegrees = request.getRotationDegrees();
        if (ImagePipeline.EXIF_ROTATION_AVAILABILITY.shouldUseExifOrientation(image)) {
            Preconditions.checkNotNull((Object)exif, (Object)"The image must have JPEG exif.");
            Preconditions.checkState((boolean)ProcessingInput2Packet.isSizeMatch(exif, image), (String)"Exif size does not match image size.");
            Matrix halTransform = ProcessingInput2Packet.getHalTransform(request.getRotationDegrees(), new Size(exif.getWidth(), exif.getHeight()), exif.getRotation());
            cropRect = ProcessingInput2Packet.getUpdatedCropRect(request.getCropRect(), halTransform);
            sensorToBuffer = ProcessingInput2Packet.getUpdatedTransform(request.getSensorToBufferTransform(), halTransform);
            rotationDegrees = exif.getRotation();
        }
        return Packet.of(image, exif, cropRect, rotationDegrees, sensorToBuffer, cameraCaptureResult);
    }

    private static boolean isSizeMatch(@NonNull Exif exif, @NonNull ImageProxy image) {
        return exif.getWidth() == image.getWidth() && exif.getHeight() == image.getHeight();
    }

    @NonNull
    private static Matrix getUpdatedTransform(@NonNull Matrix sensorToSurface, @NonNull Matrix halTransform) {
        Matrix sensorToBuffer = new Matrix(sensorToSurface);
        sensorToBuffer.postConcat(halTransform);
        return sensorToBuffer;
    }

    @NonNull
    private static Rect getUpdatedCropRect(@NonNull Rect cropRect, @NonNull Matrix halTransform) {
        RectF rectF = new RectF(cropRect);
        halTransform.mapRect(rectF);
        Rect rect = new Rect();
        rectF.round(rect);
        return rect;
    }

    @NonNull
    private static Matrix getHalTransform(@IntRange(from=0L, to=359L) int requestRotationDegrees, @NonNull Size imageSize, @IntRange(from=0L, to=359L) int exifRotationDegrees) {
        int halRotationDegrees = requestRotationDegrees - exifRotationDegrees;
        Size surfaceSize = TransformUtils.is90or270(TransformUtils.within360(halRotationDegrees)) ? new Size(imageSize.getHeight(), imageSize.getWidth()) : imageSize;
        return TransformUtils.getRectToRect(new RectF(0.0f, 0.0f, (float)surfaceSize.getWidth(), (float)surfaceSize.getHeight()), new RectF(0.0f, 0.0f, (float)imageSize.getWidth(), (float)imageSize.getHeight()), halRotationDegrees);
    }
}

