/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.core.impl.quirk.ProfileResolutionQuirk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@RequiresApi(value=21)
public class EncoderProfilesResolutionValidator {
    @NonNull
    private final List<ProfileResolutionQuirk> mQuirks = new ArrayList<ProfileResolutionQuirk>();
    @NonNull
    private final Set<Size> mSupportedResolutions;

    public EncoderProfilesResolutionValidator(@Nullable List<ProfileResolutionQuirk> quirks) {
        if (quirks != null) {
            this.mQuirks.addAll(quirks);
        }
        this.mSupportedResolutions = this.generateSupportedResolutions(quirks);
    }

    @NonNull
    private Set<Size> generateSupportedResolutions(@Nullable List<ProfileResolutionQuirk> quirks) {
        if (quirks == null || quirks.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Size> supportedResolutions = new HashSet<Size>(quirks.get(0).getSupportedResolutions());
        for (int i = 1; i < quirks.size(); ++i) {
            supportedResolutions.retainAll(quirks.get(i).getSupportedResolutions());
        }
        return supportedResolutions;
    }

    public boolean hasQuirk() {
        return !this.mQuirks.isEmpty();
    }

    public boolean hasValidVideoResolution(@Nullable EncoderProfilesProxy profiles) {
        if (profiles == null) {
            return false;
        }
        if (!this.hasQuirk()) {
            return !profiles.getVideoProfiles().isEmpty();
        }
        boolean hasValidResolution = false;
        for (EncoderProfilesProxy.VideoProfileProxy videoProfile : profiles.getVideoProfiles()) {
            Size videoSize = new Size(videoProfile.getWidth(), videoProfile.getHeight());
            if (!this.mSupportedResolutions.contains(videoSize)) continue;
            hasValidResolution = true;
            break;
        }
        return hasValidResolution;
    }

    @Nullable
    public EncoderProfilesProxy filterInvalidVideoResolution(@Nullable EncoderProfilesProxy profiles) {
        if (profiles == null) {
            return null;
        }
        if (!this.hasQuirk()) {
            return profiles;
        }
        ArrayList<EncoderProfilesProxy.VideoProfileProxy> validVideoProfiles = new ArrayList<EncoderProfilesProxy.VideoProfileProxy>();
        for (EncoderProfilesProxy.VideoProfileProxy videoProfile : profiles.getVideoProfiles()) {
            Size videoSize = new Size(videoProfile.getWidth(), videoProfile.getHeight());
            if (!this.mSupportedResolutions.contains(videoSize)) continue;
            validVideoProfiles.add(videoProfile);
        }
        return validVideoProfiles.isEmpty() ? null : EncoderProfilesProxy.ImmutableEncoderProfilesProxy.create(profiles.getDefaultDurationSeconds(), profiles.getRecommendedFileFormat(), profiles.getAudioProfiles(), validVideoProfiles);
    }
}

