/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.AutoValue_CameraState;
import androidx.camera.core.AutoValue_CameraState_StateError;
import com.google.auto.value.AutoValue;

@RequiresApi(value=21)
@AutoValue
public abstract class CameraState {
    public static final int ERROR_MAX_CAMERAS_IN_USE = 1;
    public static final int ERROR_CAMERA_IN_USE = 2;
    public static final int ERROR_OTHER_RECOVERABLE_ERROR = 3;
    public static final int ERROR_STREAM_CONFIG = 4;
    public static final int ERROR_CAMERA_DISABLED = 5;
    public static final int ERROR_CAMERA_FATAL_ERROR = 6;
    public static final int ERROR_DO_NOT_DISTURB_MODE_ENABLED = 7;

    @NonNull
    public static CameraState create(@NonNull Type type) {
        return CameraState.create(type, null);
    }

    @NonNull
    public static CameraState create(@NonNull Type type, @Nullable StateError error) {
        return new AutoValue_CameraState(type, error);
    }

    @NonNull
    public abstract Type getType();

    @Nullable
    public abstract StateError getError();

    public static enum Type {
        PENDING_OPEN,
        OPENING,
        OPEN,
        CLOSING,
        CLOSED;

    }

    @AutoValue
    public static abstract class StateError {
        @NonNull
        public static StateError create(int error) {
            return StateError.create(error, null);
        }

        @NonNull
        public static StateError create(int error, @Nullable Throwable cause) {
            return new AutoValue_CameraState_StateError(error, cause);
        }

        public abstract int getCode();

        @Nullable
        public abstract Throwable getCause();

        @NonNull
        public ErrorType getType() {
            int code = this.getCode();
            if (code == 2 || code == 1 || code == 3) {
                return ErrorType.RECOVERABLE;
            }
            return ErrorType.CRITICAL;
        }
    }

    public static enum ErrorType {
        RECOVERABLE,
        CRITICAL;

    }
}

