/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;

@RequiresApi(value=21)
public final class ContextUtil {
    @NonNull
    public static Context getApplicationContext(@NonNull Context context) {
        String attributeTag;
        Context applicationContext = context.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 30 && (attributeTag = Api30Impl.getAttributionTag(context)) != null) {
            return Api30Impl.createAttributionContext(applicationContext, attributeTag);
        }
        return applicationContext;
    }

    @NonNull
    public static Context getBaseContext(@NonNull ContextWrapper context) {
        String attributeTag;
        Context baseContext = context.getBaseContext();
        if (Build.VERSION.SDK_INT >= 30 && (attributeTag = Api30Impl.getAttributionTag((Context)context)) != null) {
            return Api30Impl.createAttributionContext(baseContext, attributeTag);
        }
        return baseContext;
    }

    @Nullable
    public static Application getApplicationFromContext(@NonNull Context context) {
        Application application = null;
        Context appContext = ContextUtil.getApplicationContext(context);
        while (appContext instanceof ContextWrapper) {
            if (appContext instanceof Application) {
                application = (Application)appContext;
                break;
            }
            appContext = ContextUtil.getBaseContext((ContextWrapper)appContext);
        }
        return application;
    }

    private ContextUtil() {
    }

    @RequiresApi(value=30)
    private static class Api30Impl {
        private Api30Impl() {
        }

        @DoNotInline
        @NonNull
        static Context createAttributionContext(@NonNull Context context, @Nullable String attributeTag) {
            return context.createAttributionContext(attributeTag);
        }

        @DoNotInline
        @Nullable
        static String getAttributionTag(@NonNull Context context) {
            return context.getAttributionTag();
        }
    }
}

