/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.location.Location;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.util.Log;
import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.GuardedBy;
import androidx.annotation.IntRange;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.CameraClosedException;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.ExperimentalZeroShutterLag;
import androidx.camera.core.ImageCaptureCapabilities;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageCaptureLatencyEstimate;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxyProvider;
import androidx.camera.core.Logger;
import androidx.camera.core.ResolutionInfo;
import androidx.camera.core.UseCase;
import androidx.camera.core.imagecapture.ImageCaptureControl;
import androidx.camera.core.imagecapture.ImagePipeline;
import androidx.camera.core.imagecapture.TakePictureManager;
import androidx.camera.core.imagecapture.TakePictureRequest;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.ImageCaptureConfig;
import androidx.camera.core.impl.ImageInputConfig;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.CameraOrientationUtil;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.IoConfig;
import androidx.camera.core.internal.SupportedOutputSizesSorter;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.compat.quirk.SoftwareJpegEncodingPreferredQuirk;
import androidx.camera.core.internal.compat.workaround.ExifRotationAvailability;
import androidx.camera.core.internal.utils.ImageUtil;
import androidx.camera.core.resolutionselector.AspectRatioStrategy;
import androidx.camera.core.resolutionselector.ResolutionSelector;
import androidx.camera.core.resolutionselector.ResolutionStrategy;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

@RequiresApi(value=21)
public final class ImageCapture
extends UseCase {
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_FILE_IO = 1;
    public static final int ERROR_CAPTURE_FAILED = 2;
    public static final int ERROR_CAMERA_CLOSED = 3;
    public static final int ERROR_INVALID_CAMERA = 4;
    public static final int CAPTURE_MODE_MAXIMIZE_QUALITY = 0;
    public static final int CAPTURE_MODE_MINIMIZE_LATENCY = 1;
    @ExperimentalZeroShutterLag
    public static final int CAPTURE_MODE_ZERO_SHUTTER_LAG = 2;
    private static final int FLASH_MODE_UNKNOWN = -1;
    public static final int FLASH_MODE_AUTO = 0;
    public static final int FLASH_MODE_ON = 1;
    public static final int FLASH_MODE_OFF = 2;
    public static final int FLASH_MODE_SCREEN = 3;
    public static final long SCREEN_FLASH_UI_APPLY_TIMEOUT_SECONDS = 3L;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int FLASH_TYPE_ONE_SHOT_FLASH = 0;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int FLASH_TYPE_USE_TORCH_AS_FLASH = 1;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Defaults DEFAULT_CONFIG = new Defaults();
    private static final String TAG = "ImageCapture";
    private static final int MAX_IMAGES = 2;
    private static final byte JPEG_QUALITY_MAXIMIZE_QUALITY_MODE = 100;
    private static final byte JPEG_QUALITY_MINIMIZE_LATENCY_MODE = 95;
    private static final int DEFAULT_CAPTURE_MODE = 1;
    private static final int DEFAULT_FLASH_MODE = 2;
    static final ExifRotationAvailability EXIF_ROTATION_AVAILABILITY = new ExifRotationAvailability();
    private final ImageReaderProxy.OnImageAvailableListener mClosingListener = imageReader -> {
        try (ImageProxy image = imageReader.acquireLatestImage();){
            Log.d((String)TAG, (String)("Discarding ImageProxy which was inadvertently acquired: " + image));
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"Failed to acquire latest image.", (Throwable)e);
        }
    };
    private final int mCaptureMode;
    @GuardedBy(value="mLockedFlashMode")
    private final AtomicReference<Integer> mLockedFlashMode = new AtomicReference<Object>(null);
    private final int mFlashType;
    @GuardedBy(value="mLockedFlashMode")
    private int mFlashMode = -1;
    private Rational mCropAspectRatio = null;
    private ScreenFlashUiControl mScreenFlashUiControl;
    SessionConfig.Builder mSessionConfigBuilder;
    @Nullable
    private ImagePipeline mImagePipeline;
    @Nullable
    private TakePictureManager mTakePictureManager;
    private final ImageCaptureControl mImageCaptureControl = new ImageCaptureControl(){

        @Override
        @MainThread
        public void lockFlashMode() {
            ImageCapture.this.lockFlashMode();
        }

        @Override
        @MainThread
        public void unlockFlashMode() {
            ImageCapture.this.unlockFlashMode();
        }

        @Override
        @MainThread
        @NonNull
        public ListenableFuture<Void> submitStillCaptureRequests(@NonNull List<CaptureConfig> captureConfigs) {
            return ImageCapture.this.submitStillCaptureRequest(captureConfigs);
        }
    };

    ImageCapture(@NonNull ImageCaptureConfig userConfig) {
        super(userConfig);
        ImageCaptureConfig useCaseConfig = (ImageCaptureConfig)this.getCurrentConfig();
        this.mCaptureMode = useCaseConfig.containsOption(ImageCaptureConfig.OPTION_IMAGE_CAPTURE_MODE) ? useCaseConfig.getCaptureMode() : 1;
        this.mFlashType = useCaseConfig.getFlashType(0);
        this.mScreenFlashUiControl = useCaseConfig.getScreenFlashUiControl();
    }

    private boolean isSessionProcessorEnabledInCurrentCamera() {
        if (this.getCamera() == null) {
            return false;
        }
        CameraConfig cameraConfig = this.getCamera().getExtendedConfig();
        return cameraConfig.getSessionProcessor(null) != null;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public UseCaseConfig<?> getDefaultConfig(boolean applyDefaultConfig, @NonNull UseCaseConfigFactory factory) {
        Config captureConfig = factory.getConfig(DEFAULT_CONFIG.getConfig().getCaptureType(), this.getCaptureMode());
        if (applyDefaultConfig) {
            captureConfig = Config.mergeConfigs(captureConfig, DEFAULT_CONFIG.getConfig());
        }
        return captureConfig == null ? null : (UseCaseConfig<?>)this.getUseCaseConfigBuilder(captureConfig).getUseCaseConfig();
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public UseCaseConfig.Builder<?, ?, ?> getUseCaseConfigBuilder(@NonNull Config config) {
        return Builder.fromConfig(config);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected UseCaseConfig<?> onMergeConfig(@NonNull CameraInfoInternal cameraInfo, @NonNull UseCaseConfig.Builder<?, ?, ?> builder) {
        if (cameraInfo.getCameraQuirks().contains(SoftwareJpegEncodingPreferredQuirk.class)) {
            if (Boolean.FALSE.equals(builder.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, true))) {
                Logger.w(TAG, "Device quirk suggests software JPEG encoder, but it has been explicitly disabled.");
            } else {
                Logger.i(TAG, "Requesting software JPEG due to device quirk.");
                builder.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, true);
            }
        }
        boolean useSoftwareJpeg = this.enforceSoftwareJpegConstraints(builder.getMutableConfig());
        Integer bufferFormat = builder.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, null);
        if (bufferFormat != null) {
            Preconditions.checkArgument((!this.isSessionProcessorEnabledInCurrentCamera() || bufferFormat == 256 ? 1 : 0) != 0, (Object)"Cannot set non-JPEG buffer format with Extensions enabled.");
            builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, useSoftwareJpeg ? 35 : bufferFormat);
        } else if (useSoftwareJpeg) {
            builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 35);
        } else {
            List supportedSizes = builder.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_SUPPORTED_RESOLUTIONS, null);
            if (supportedSizes == null) {
                builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 256);
            } else if (ImageCapture.isImageFormatSupported(supportedSizes, 256)) {
                builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 256);
            } else if (ImageCapture.isImageFormatSupported(supportedSizes, 35)) {
                builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 35);
            }
        }
        return builder.getUseCaseConfig();
    }

    private static boolean isImageFormatSupported(List<Pair<Integer, Size[]>> supportedSizes, int imageFormat) {
        if (supportedSizes == null) {
            return false;
        }
        for (Pair<Integer, Size[]> supportedSize : supportedSizes) {
            if (!((Integer)supportedSize.first).equals(imageFormat)) continue;
            return true;
        }
        return false;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onCameraControlReady() {
        this.trySetFlashModeToCameraControl();
        this.setScreenFlashUiControlToCameraControl();
    }

    private int getCameraLens() {
        CameraInternal camera = this.getCamera();
        if (camera != null) {
            return camera.getCameraInfo().getLensFacing();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFlashMode() {
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            return this.mFlashMode != -1 ? this.mFlashMode : ((ImageCaptureConfig)this.getCurrentConfig()).getFlashMode(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlashMode(int flashMode) {
        if (flashMode != 0 && flashMode != 1 && flashMode != 2) {
            if (flashMode == 3) {
                if (this.mScreenFlashUiControl == null) {
                    throw new IllegalArgumentException("ScreenFlashUiControl not set for FLASH_MODE_SCREEN");
                }
                if (this.getCamera() != null && this.getCameraLens() != 0) {
                    throw new IllegalArgumentException("Not a front camera despite setting FLASH_MODE_SCREEN");
                }
            } else {
                throw new IllegalArgumentException("Invalid flash mode: " + flashMode);
            }
        }
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            this.mFlashMode = flashMode;
            this.trySetFlashModeToCameraControl();
        }
    }

    public void setScreenFlashUiControl(@Nullable ScreenFlashUiControl screenFlashUiControl) {
        this.mScreenFlashUiControl = screenFlashUiControl;
        this.setScreenFlashUiControlToCameraControl();
    }

    @Nullable
    public ScreenFlashUiControl getScreenFlashUiControl() {
        return this.mScreenFlashUiControl;
    }

    private void setScreenFlashUiControlToCameraControl() {
        this.getCameraControl().setScreenFlashUiControl(this.mScreenFlashUiControl);
    }

    public void setCropAspectRatio(@NonNull Rational aspectRatio) {
        this.mCropAspectRatio = aspectRatio;
    }

    public int getTargetRotation() {
        return this.getTargetRotationInternal();
    }

    public void setTargetRotation(int rotation) {
        int oldRotation = this.getTargetRotation();
        if (this.setTargetRotationInternal(rotation) && this.mCropAspectRatio != null) {
            int oldRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees(oldRotation);
            int newRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees(rotation);
            this.mCropAspectRatio = ImageUtil.getRotatedAspectRatio(Math.abs(newRotationDegrees - oldRotationDegrees), this.mCropAspectRatio);
        }
    }

    public int getCaptureMode() {
        return this.mCaptureMode;
    }

    @IntRange(from=1L, to=100L)
    public int getJpegQuality() {
        return this.getJpegQualityInternal();
    }

    @Nullable
    public ResolutionInfo getResolutionInfo() {
        return this.getResolutionInfoInternal();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    protected ResolutionInfo getResolutionInfoInternal() {
        CameraInternal camera = this.getCamera();
        Size resolution = this.getAttachedSurfaceResolution();
        if (camera == null || resolution == null) {
            return null;
        }
        Rect cropRect = this.getViewPortCropRect();
        Rational cropAspectRatio = this.mCropAspectRatio;
        if (cropRect == null) {
            cropRect = cropAspectRatio != null ? ImageUtil.computeCropRectFromAspectRatio(resolution, cropAspectRatio) : new Rect(0, 0, resolution.getWidth(), resolution.getHeight());
        }
        int rotationDegrees = this.getRelativeRotation(camera);
        return new ResolutionInfo(resolution, Objects.requireNonNull(cropRect), rotationDegrees);
    }

    @Nullable
    public ResolutionSelector getResolutionSelector() {
        return ((ImageOutputConfig)((Object)this.getCurrentConfig())).getResolutionSelector(null);
    }

    public void takePicture(@NonNull Executor executor, @NonNull OnImageCapturedCallback callback) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            CameraXExecutors.mainThreadExecutor().execute(() -> this.takePicture(executor, callback));
            return;
        }
        this.takePictureInternal(executor, callback, null, null);
    }

    public void takePicture(@NonNull OutputFileOptions outputFileOptions, @NonNull Executor executor, @NonNull OnImageSavedCallback imageSavedCallback) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            CameraXExecutors.mainThreadExecutor().execute(() -> this.takePicture(outputFileOptions, executor, imageSavedCallback));
            return;
        }
        this.takePictureInternal(executor, null, imageSavedCallback, outputFileOptions);
    }

    @NonNull
    public static ImageCaptureCapabilities getImageCaptureCapabilities(@NonNull CameraInfo cameraInfo) {
        return new ImageCaptureCapabilitiesImpl(cameraInfo);
    }

    @NonNull
    static Rect computeDispatchCropRect(@Nullable Rect viewPortCropRect, @Nullable Rational cropAspectRatio, int rotationDegrees, @NonNull Size dispatchResolution, int dispatchRotationDegrees) {
        if (viewPortCropRect != null) {
            return ImageUtil.computeCropRectFromDispatchInfo(viewPortCropRect, rotationDegrees, dispatchResolution, dispatchRotationDegrees);
        }
        if (cropAspectRatio != null) {
            Rational aspectRatio = cropAspectRatio;
            if (dispatchRotationDegrees % 180 != 0) {
                aspectRatio = new Rational(cropAspectRatio.getDenominator(), cropAspectRatio.getNumerator());
            }
            if (ImageUtil.isAspectRatioValid(dispatchResolution, aspectRatio)) {
                return Objects.requireNonNull(ImageUtil.computeCropRectFromAspectRatio(dispatchResolution, aspectRatio));
            }
        }
        return new Rect(0, 0, dispatchResolution.getWidth(), dispatchResolution.getHeight());
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @UiThread
    public void onStateDetached() {
        this.abortImageCaptureRequests();
    }

    @UiThread
    private void abortImageCaptureRequests() {
        if (this.mTakePictureManager != null) {
            this.mTakePictureManager.abortRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockFlashMode() {
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            if (this.mLockedFlashMode.get() != null) {
                return;
            }
            this.mLockedFlashMode.set(this.getFlashMode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlockFlashMode() {
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            Integer lockedFlashMode = this.mLockedFlashMode.getAndSet(null);
            if (lockedFlashMode == null) {
                return;
            }
            if (lockedFlashMode.intValue() != this.getFlashMode()) {
                this.trySetFlashModeToCameraControl();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySetFlashModeToCameraControl() {
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            if (this.mLockedFlashMode.get() != null) {
                return;
            }
            this.getCameraControl().setFlashMode(this.getFlashMode());
        }
    }

    @IntRange(from=1L, to=100L)
    private int getJpegQualityInternal() {
        ImageCaptureConfig imageCaptureConfig = (ImageCaptureConfig)this.getCurrentConfig();
        if (imageCaptureConfig.containsOption(ImageCaptureConfig.OPTION_JPEG_COMPRESSION_QUALITY)) {
            return imageCaptureConfig.getJpegQuality();
        }
        switch (this.mCaptureMode) {
            case 0: {
                return 100;
            }
            case 1: 
            case 2: {
                return 95;
            }
        }
        throw new IllegalStateException("CaptureMode " + this.mCaptureMode + " is invalid");
    }

    @NonNull
    public String toString() {
        return "ImageCapture:" + this.getName();
    }

    static int getError(Throwable throwable) {
        if (throwable instanceof CameraClosedException) {
            return 3;
        }
        if (throwable instanceof ImageCaptureException) {
            return ((ImageCaptureException)throwable).getImageCaptureError();
        }
        return 0;
    }

    boolean enforceSoftwareJpegConstraints(@NonNull MutableConfig mutableConfig) {
        if (Boolean.TRUE.equals(mutableConfig.retrieveOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, false))) {
            Integer bufferFormat;
            boolean supported = true;
            if (this.isSessionProcessorEnabledInCurrentCamera()) {
                Logger.w(TAG, "Software JPEG cannot be used with Extensions.");
                supported = false;
            }
            if ((bufferFormat = (Integer)mutableConfig.retrieveOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, null)) != null && bufferFormat != 256) {
                Logger.w(TAG, "Software JPEG cannot be used with non-JPEG output buffer format.");
                supported = false;
            }
            if (!supported) {
                Logger.w(TAG, "Unable to support software JPEG. Disabling.");
                mutableConfig.insertOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, false);
            }
            return supported;
        }
        return false;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onUnbind() {
        this.abortImageCaptureRequests();
        this.clearPipeline();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onBind() {
        CameraInternal camera = this.getCamera();
        Preconditions.checkNotNull((Object)camera, (Object)"Attached camera cannot be null");
        if (this.getFlashMode() == 3 && this.getCameraLens() != 0) {
            throw new IllegalArgumentException("Not a front camera despite setting FLASH_MODE_SCREEN in ImageCapture");
        }
    }

    @Nullable
    private SessionProcessor getSessionProcessor() {
        CameraConfig cameraConfig = this.getCamera().getExtendedConfig();
        return cameraConfig.getSessionProcessor(null);
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected StreamSpec onSuggestedStreamSpecUpdated(@NonNull StreamSpec suggestedStreamSpec) {
        this.mSessionConfigBuilder = this.createPipeline(this.getCameraId(), (ImageCaptureConfig)this.getCurrentConfig(), suggestedStreamSpec);
        this.updateSessionConfig(this.mSessionConfigBuilder.build());
        this.notifyActive();
        return suggestedStreamSpec;
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected StreamSpec onSuggestedStreamSpecImplementationOptionsUpdated(@NonNull Config config) {
        this.mSessionConfigBuilder.addImplementationOptions(config);
        this.updateSessionConfig(this.mSessionConfigBuilder.build());
        return this.getAttachedStreamSpec().toBuilder().setImplementationOptions(config).build();
    }

    @OptIn(markerClass={ExperimentalZeroShutterLag.class})
    @MainThread
    private SessionConfig.Builder createPipeline(@NonNull String cameraId, @NonNull ImageCaptureConfig config, @NonNull StreamSpec streamSpec) {
        SessionProcessor sessionProcessor;
        boolean isVirtualCamera;
        Threads.checkMainThread();
        Log.d((String)TAG, (String)String.format("createPipeline(cameraId: %s, streamSpec: %s)", cameraId, streamSpec));
        Size resolution = streamSpec.getResolution();
        boolean bl = isVirtualCamera = !Objects.requireNonNull(this.getCamera()).getHasTransform() || this.isSessionProcessorEnabledInCurrentCamera();
        if (this.mImagePipeline != null) {
            Preconditions.checkState((boolean)isVirtualCamera);
            this.mImagePipeline.close();
        }
        boolean isPostviewEnabled = this.getCurrentConfig().retrieveOption(ImageCaptureConfig.OPTION_POSTVIEW_ENABLED, false);
        Size postViewSize = null;
        int postviewFormat = 35;
        if (isPostviewEnabled && (sessionProcessor = this.getSessionProcessor()) != null) {
            ResolutionSelector postviewSizeSelector = this.getCurrentConfig().retrieveOption(ImageCaptureConfig.OPTION_POSTVIEW_RESOLUTION_SELECTOR, null);
            Map<Integer, List<Size>> map = sessionProcessor.getSupportedPostviewSize(resolution);
            List<Size> sizes = map.get(35);
            if (sizes == null || sizes.isEmpty()) {
                sizes = map.get(256);
                postviewFormat = 256;
            }
            if (sizes != null && !sizes.isEmpty()) {
                if (postviewSizeSelector != null) {
                    Collections.sort(sizes, new CompareSizesByArea(true));
                    CameraInternal camera = this.getCamera();
                    Rect sensorRect = camera.getCameraControlInternal().getSensorRect();
                    CameraInfoInternal cameraInfo = camera.getCameraInfoInternal();
                    Rational fullFov = new Rational(sensorRect.width(), sensorRect.height());
                    List<Size> result = SupportedOutputSizesSorter.sortSupportedOutputSizesByResolutionSelector(postviewSizeSelector, sizes, null, this.getTargetRotation(), fullFov, cameraInfo.getSensorRotationDegrees(), cameraInfo.getLensFacing());
                    if (result.isEmpty()) {
                        throw new IllegalArgumentException("The postview ResolutionSelector cannot select a valid size for the postview.");
                    }
                    postViewSize = result.get(0);
                } else {
                    postViewSize = Collections.max(sizes, new CompareSizesByArea());
                }
            }
        }
        this.mImagePipeline = new ImagePipeline(config, resolution, this.getEffect(), isVirtualCamera, postViewSize, postviewFormat);
        if (this.mTakePictureManager == null) {
            this.mTakePictureManager = new TakePictureManager(this.mImageCaptureControl);
        }
        this.mTakePictureManager.setImagePipeline(this.mImagePipeline);
        SessionConfig.Builder sessionConfigBuilder = this.mImagePipeline.createSessionConfigBuilder(streamSpec.getResolution());
        if (Build.VERSION.SDK_INT >= 23 && this.getCaptureMode() == 2) {
            this.getCameraControl().addZslConfig(sessionConfigBuilder);
        }
        if (streamSpec.getImplementationOptions() != null) {
            sessionConfigBuilder.addImplementationOptions(streamSpec.getImplementationOptions());
        }
        sessionConfigBuilder.addErrorListener((sessionConfig, error) -> {
            if (this.isCurrentCamera(cameraId)) {
                this.mTakePictureManager.pause();
                this.clearPipeline(true);
                this.mSessionConfigBuilder = this.createPipeline(cameraId, config, streamSpec);
                this.updateSessionConfig(this.mSessionConfigBuilder.build());
                this.notifyReset();
                this.mTakePictureManager.resume();
            } else {
                this.clearPipeline();
            }
        });
        return sessionConfigBuilder;
    }

    @MainThread
    private void takePictureInternal(@NonNull Executor executor, @Nullable OnImageCapturedCallback inMemoryCallback, @Nullable OnImageSavedCallback onDiskCallback, @Nullable OutputFileOptions outputFileOptions) {
        Threads.checkMainThread();
        if (this.getFlashMode() == 3 && this.mScreenFlashUiControl == null) {
            throw new IllegalArgumentException("ScreenFlashUiControl not set for FLASH_MODE_SCREEN");
        }
        Log.d((String)TAG, (String)"takePictureInternal");
        CameraInternal camera = this.getCamera();
        if (camera == null) {
            this.sendInvalidCameraError(executor, inMemoryCallback, onDiskCallback);
            return;
        }
        Objects.requireNonNull(this.mTakePictureManager).offerRequest(TakePictureRequest.of(executor, inMemoryCallback, onDiskCallback, outputFileOptions, this.getTakePictureCropRect(), this.getSensorToBufferTransformMatrix(), this.getRelativeRotation(camera), this.getJpegQualityInternal(), this.getCaptureMode(), this.mSessionConfigBuilder.getSingleCameraCaptureCallbacks()));
    }

    private void sendInvalidCameraError(@NonNull Executor executor, @Nullable OnImageCapturedCallback inMemoryCallback, @Nullable OnImageSavedCallback onDiskCallback) {
        ImageCaptureException exception = new ImageCaptureException(4, "Not bound to a valid Camera [" + this + "]", null);
        if (inMemoryCallback != null) {
            inMemoryCallback.onError(exception);
        } else if (onDiskCallback != null) {
            onDiskCallback.onError(exception);
        } else {
            throw new IllegalArgumentException("Must have either in-memory or on-disk callback.");
        }
    }

    @NonNull
    private Rect getTakePictureCropRect() {
        Rect rect = this.getViewPortCropRect();
        Size resolution = Objects.requireNonNull(this.getAttachedSurfaceResolution());
        if (rect != null) {
            return rect;
        }
        if (ImageUtil.isAspectRatioValid(this.mCropAspectRatio)) {
            int rotationDegrees = this.getRelativeRotation(Objects.requireNonNull(this.getCamera()));
            Rational rotatedAspectRatio = new Rational(this.mCropAspectRatio.getDenominator(), this.mCropAspectRatio.getNumerator());
            Rational sensorCropRatio = TransformUtils.is90or270(rotationDegrees) ? rotatedAspectRatio : this.mCropAspectRatio;
            return Objects.requireNonNull(ImageUtil.computeCropRectFromAspectRatio(resolution, sensorCropRatio));
        }
        return new Rect(0, 0, resolution.getWidth(), resolution.getHeight());
    }

    @MainThread
    private void clearPipeline() {
        this.clearPipeline(false);
    }

    @MainThread
    private void clearPipeline(boolean keepTakePictureManager) {
        Log.d((String)TAG, (String)"clearPipeline");
        Threads.checkMainThread();
        if (this.mImagePipeline != null) {
            this.mImagePipeline.close();
            this.mImagePipeline = null;
        }
        if (!keepTakePictureManager && this.mTakePictureManager != null) {
            this.mTakePictureManager.abortRequests();
            this.mTakePictureManager = null;
        }
    }

    @MainThread
    ListenableFuture<Void> submitStillCaptureRequest(@NonNull List<CaptureConfig> captureConfigs) {
        Threads.checkMainThread();
        return Futures.transform(this.getCameraControl().submitStillCaptureRequests(captureConfigs, this.mCaptureMode, this.mFlashType), input -> null, CameraXExecutors.directExecutor());
    }

    @VisibleForTesting
    boolean isProcessingPipelineEnabled() {
        return this.mImagePipeline != null && this.mTakePictureManager != null;
    }

    @Nullable
    @VisibleForTesting
    ImagePipeline getImagePipeline() {
        return this.mImagePipeline;
    }

    @VisibleForTesting
    @NonNull
    TakePictureManager getTakePictureManager() {
        return Objects.requireNonNull(this.mTakePictureManager);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Set<Integer> getSupportedEffectTargets() {
        HashSet<Integer> targets = new HashSet<Integer>();
        targets.add(4);
        return targets;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public ImageCaptureLatencyEstimate getRealtimeCaptureLatencyEstimate() {
        CameraInternal camera = this.getCamera();
        if (camera == null) {
            return ImageCaptureLatencyEstimate.UNDEFINED_IMAGE_CAPTURE_LATENCY;
        }
        CameraConfig config = camera.getExtendedConfig();
        SessionProcessor sessionProcessor = config.getSessionProcessor();
        Pair<Long, Long> latencyEstimate = sessionProcessor.getRealtimeCaptureLatency();
        if (latencyEstimate == null) {
            return ImageCaptureLatencyEstimate.UNDEFINED_IMAGE_CAPTURE_LATENCY;
        }
        return new ImageCaptureLatencyEstimate((Long)latencyEstimate.first, (Long)latencyEstimate.second);
    }

    public boolean isPostviewEnabled() {
        return this.getCurrentConfig().retrieveOption(ImageCaptureConfig.OPTION_POSTVIEW_ENABLED, false);
    }

    @Nullable
    public ResolutionSelector getPostviewResolutionSelector() {
        return this.getCurrentConfig().retrieveOption(ImageCaptureConfig.OPTION_POSTVIEW_RESOLUTION_SELECTOR, null);
    }

    public static interface ScreenFlashUiControl {
        @UiThread
        public void applyScreenFlashUi(@NonNull ScreenFlashUiCompleter var1);

        @UiThread
        public void clearScreenFlashUi();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Defaults
    implements ConfigProvider<ImageCaptureConfig> {
        private static final int DEFAULT_SURFACE_OCCUPANCY_PRIORITY = 4;
        private static final int DEFAULT_ASPECT_RATIO = 0;
        private static final ResolutionSelector DEFAULT_RESOLUTION_SELECTOR = new ResolutionSelector.Builder().setAspectRatioStrategy(AspectRatioStrategy.RATIO_4_3_FALLBACK_AUTO_STRATEGY).setResolutionStrategy(ResolutionStrategy.HIGHEST_AVAILABLE_STRATEGY).build();
        private static final ImageCaptureConfig DEFAULT_CONFIG;
        private static final DynamicRange DEFAULT_DYNAMIC_RANGE;

        @Override
        @NonNull
        public ImageCaptureConfig getConfig() {
            return DEFAULT_CONFIG;
        }

        static {
            DEFAULT_DYNAMIC_RANGE = DynamicRange.SDR;
            Builder builder = new Builder().setSurfaceOccupancyPriority(4).setTargetAspectRatio(0).setResolutionSelector(DEFAULT_RESOLUTION_SELECTOR).setDynamicRange(DEFAULT_DYNAMIC_RANGE);
            DEFAULT_CONFIG = builder.getUseCaseConfig();
        }
    }

    public static final class Builder
    implements UseCaseConfig.Builder<ImageCapture, ImageCaptureConfig, Builder>,
    ImageOutputConfig.Builder<Builder>,
    IoConfig.Builder<Builder>,
    ImageInputConfig.Builder<Builder> {
        private final MutableOptionsBundle mMutableConfig;

        public Builder() {
            this(MutableOptionsBundle.create());
        }

        private Builder(MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            Class oldConfigClass = mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(ImageCapture.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setCaptureType(UseCaseConfigFactory.CaptureType.IMAGE_CAPTURE);
            this.setTargetClass((Class)ImageCapture.class);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static Builder fromConfig(@NonNull Config configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        static Builder fromConfig(@NonNull ImageCaptureConfig configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public ImageCaptureConfig getUseCaseConfig() {
            return new ImageCaptureConfig(OptionsBundle.from(this.mMutableConfig));
        }

        @Override
        @NonNull
        public ImageCapture build() {
            Integer bufferFormat = this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, null);
            if (bufferFormat != null) {
                this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, bufferFormat);
            } else {
                this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 256);
            }
            ImageCaptureConfig imageCaptureConfig = this.getUseCaseConfig();
            ImageOutputConfig.validateConfig(imageCaptureConfig);
            ImageCapture imageCapture = new ImageCapture(imageCaptureConfig);
            Size targetResolution = this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_TARGET_RESOLUTION, null);
            if (targetResolution != null) {
                imageCapture.setCropAspectRatio(new Rational(targetResolution.getWidth(), targetResolution.getHeight()));
            }
            Preconditions.checkNotNull((Object)this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_IO_EXECUTOR, CameraXExecutors.ioExecutor()), (Object)"The IO executor can't be null");
            if (this.getMutableConfig().containsOption(ImageCaptureConfig.OPTION_FLASH_MODE)) {
                Integer flashMode = this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_FLASH_MODE);
                if (flashMode == null || flashMode != 0 && flashMode != 1 && flashMode != 3 && flashMode != 2) {
                    throw new IllegalArgumentException("The flash mode is not allowed to set: " + flashMode);
                }
                if (flashMode == 3 && this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_SCREEN_FLASH_UI_CONTROL, null) == null) {
                    throw new IllegalArgumentException("The flash mode is not allowed to set to FLASH_MODE_SCREEN without setting ScreenFlashUiControl");
                }
            }
            return imageCapture;
        }

        @NonNull
        public Builder setCaptureMode(int captureMode) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_IMAGE_CAPTURE_MODE, captureMode);
            return this;
        }

        @NonNull
        public Builder setFlashMode(int flashMode) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_FLASH_MODE, flashMode);
            return this;
        }

        @NonNull
        public Builder setScreenFlashUiControl(@NonNull ScreenFlashUiControl screenFlashUiControl) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_SCREEN_FLASH_UI_CONTROL, screenFlashUiControl);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setBufferFormat(int bufferImageFormat) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, bufferImageFormat);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> resolutions) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_SUPPORTED_RESOLUTIONS, resolutions);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCustomOrderedResolutions(@NonNull List<Size> resolutions) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_CUSTOM_ORDERED_RESOLUTIONS, resolutions);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setTargetClass(@NonNull Class<ImageCapture> targetClass) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_NAME, targetName);
            return this;
        }

        @Override
        @Deprecated
        @NonNull
        public Builder setTargetAspectRatio(int aspectRatio) {
            if (aspectRatio == -1) {
                aspectRatio = 0;
            }
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_ASPECT_RATIO, aspectRatio);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetRotation(int rotation) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_ROTATION, rotation);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setMirrorMode(int mirrorMode) {
            throw new UnsupportedOperationException("setMirrorMode is not supported.");
        }

        @Override
        @Deprecated
        @NonNull
        public Builder setTargetResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setDefaultResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_DEFAULT_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setMaxResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_MAX_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        public Builder setResolutionSelector(@NonNull ResolutionSelector resolutionSelector) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_RESOLUTION_SELECTOR, resolutionSelector);
            return this;
        }

        @NonNull
        public Builder setPostviewEnabled(boolean postviewEnabled) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_POSTVIEW_ENABLED, postviewEnabled);
            return this;
        }

        @NonNull
        public Builder setPostviewResolutionSelector(@NonNull ResolutionSelector resolutionSelector) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_POSTVIEW_RESOLUTION_SELECTOR, resolutionSelector);
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setImageReaderProxyProvider(@NonNull ImageReaderProxyProvider imageReaderProxyProvider) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_IMAGE_READER_PROXY_PROVIDER, imageReaderProxyProvider);
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setSoftwareJpegEncoderRequested(boolean requestSoftwareJpeg) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, requestSoftwareJpeg);
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setFlashType(int flashType) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_FLASH_TYPE, flashType);
            return this;
        }

        @NonNull
        public Builder setJpegQuality(@IntRange(from=1L, to=100L) int jpegQuality) {
            Preconditions.checkArgumentInRange((int)jpegQuality, (int)1, (int)100, (String)"jpegQuality");
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_JPEG_COMPRESSION_QUALITY, jpegQuality);
            return this;
        }

        @Override
        @NonNull
        public Builder setIoExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_IO_EXECUTOR, executor);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_DEFAULT_SESSION_CONFIG, sessionConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_DEFAULT_CAPTURE_CONFIG, captureConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_SESSION_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_CAPTURE_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSurfaceOccupancyPriority(int priority) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, priority);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setUseCaseEventCallback(@NonNull UseCase.EventCallback useCaseEventCallback) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_USE_CASE_EVENT_CALLBACK, useCaseEventCallback);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setZslDisabled(boolean disabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_ZSL_DISABLED, disabled);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setHighResolutionDisabled(boolean disabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_HIGH_RESOLUTION_DISABLED, disabled);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureType(@NonNull UseCaseConfigFactory.CaptureType captureType) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAPTURE_TYPE, captureType);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        public Builder setDynamicRange(@NonNull DynamicRange dynamicRange) {
            if (!Objects.equals(DynamicRange.SDR, dynamicRange)) {
                throw new UnsupportedOperationException("ImageCapture currently only supports SDR");
            }
            this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_DYNAMIC_RANGE, dynamicRange);
            return this;
        }
    }

    public static abstract class OnImageCapturedCallback {
        public void onCaptureStarted() {
        }

        public void onCaptureSuccess(@NonNull ImageProxy image) {
        }

        public void onError(@NonNull ImageCaptureException exception) {
        }

        public void onCaptureProcessProgressed(int progress) {
        }

        public void onPostviewBitmapAvailable(@NonNull Bitmap bitmap) {
        }
    }

    public static interface OnImageSavedCallback {
        default public void onCaptureStarted() {
        }

        public void onImageSaved(@NonNull OutputFileResults var1);

        public void onError(@NonNull ImageCaptureException var1);

        default public void onCaptureProcessProgressed(int progress) {
        }

        default public void onPostviewBitmapAvailable(@NonNull Bitmap bitmap) {
        }
    }

    public static final class OutputFileOptions {
        @Nullable
        private final File mFile;
        @Nullable
        private final ContentResolver mContentResolver;
        @Nullable
        private final Uri mSaveCollection;
        @Nullable
        private final ContentValues mContentValues;
        @Nullable
        private final OutputStream mOutputStream;
        @NonNull
        private final Metadata mMetadata;

        OutputFileOptions(@Nullable File file, @Nullable ContentResolver contentResolver, @Nullable Uri saveCollection, @Nullable ContentValues contentValues, @Nullable OutputStream outputStream, @Nullable Metadata metadata) {
            this.mFile = file;
            this.mContentResolver = contentResolver;
            this.mSaveCollection = saveCollection;
            this.mContentValues = contentValues;
            this.mOutputStream = outputStream;
            this.mMetadata = metadata == null ? new Metadata() : metadata;
        }

        @Nullable
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public File getFile() {
            return this.mFile;
        }

        @Nullable
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public ContentResolver getContentResolver() {
            return this.mContentResolver;
        }

        @Nullable
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Uri getSaveCollection() {
            return this.mSaveCollection;
        }

        @Nullable
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public ContentValues getContentValues() {
            return this.mContentValues;
        }

        @Nullable
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public OutputStream getOutputStream() {
            return this.mOutputStream;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Metadata getMetadata() {
            return this.mMetadata;
        }

        @NonNull
        public String toString() {
            return "OutputFileOptions{mFile=" + this.mFile + ", mContentResolver=" + this.mContentResolver + ", mSaveCollection=" + this.mSaveCollection + ", mContentValues=" + this.mContentValues + ", mOutputStream=" + this.mOutputStream + ", mMetadata=" + this.mMetadata + "}";
        }

        public static final class Builder {
            @Nullable
            private File mFile;
            @Nullable
            private ContentResolver mContentResolver;
            @Nullable
            private Uri mSaveCollection;
            @Nullable
            private ContentValues mContentValues;
            @Nullable
            private OutputStream mOutputStream;
            @Nullable
            private Metadata mMetadata;

            public Builder(@NonNull File file) {
                this.mFile = file;
            }

            public Builder(@NonNull ContentResolver contentResolver, @NonNull Uri saveCollection, @NonNull ContentValues contentValues) {
                this.mContentResolver = contentResolver;
                this.mSaveCollection = saveCollection;
                this.mContentValues = contentValues;
            }

            public Builder(@NonNull OutputStream outputStream) {
                this.mOutputStream = outputStream;
            }

            @NonNull
            public Builder setMetadata(@NonNull Metadata metadata) {
                this.mMetadata = metadata;
                return this;
            }

            @NonNull
            public OutputFileOptions build() {
                return new OutputFileOptions(this.mFile, this.mContentResolver, this.mSaveCollection, this.mContentValues, this.mOutputStream, this.mMetadata);
            }
        }
    }

    private static class ImageCaptureCapabilitiesImpl
    implements ImageCaptureCapabilities {
        private final CameraInfo mCameraInfo;

        ImageCaptureCapabilitiesImpl(@NonNull CameraInfo cameraInfo) {
            this.mCameraInfo = cameraInfo;
        }

        @Override
        public boolean isPostviewSupported() {
            if (this.mCameraInfo instanceof CameraInfoInternal) {
                return ((CameraInfoInternal)this.mCameraInfo).isPostviewSupported();
            }
            return false;
        }

        @Override
        public boolean isCaptureProcessProgressSupported() {
            if (this.mCameraInfo instanceof CameraInfoInternal) {
                return ((CameraInfoInternal)this.mCameraInfo).isCaptureProcessProgressSupported();
            }
            return false;
        }
    }

    public static final class Metadata {
        private boolean mIsReversedHorizontal;
        private boolean mIsReversedHorizontalSet = false;
        private boolean mIsReversedVertical;
        @Nullable
        private Location mLocation;

        public boolean isReversedHorizontal() {
            return this.mIsReversedHorizontal;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public boolean isReversedHorizontalSet() {
            return this.mIsReversedHorizontalSet;
        }

        public void setReversedHorizontal(boolean isReversedHorizontal) {
            this.mIsReversedHorizontal = isReversedHorizontal;
            this.mIsReversedHorizontalSet = true;
        }

        public boolean isReversedVertical() {
            return this.mIsReversedVertical;
        }

        public void setReversedVertical(boolean isReversedVertical) {
            this.mIsReversedVertical = isReversedVertical;
        }

        @Nullable
        public Location getLocation() {
            return this.mLocation;
        }

        public void setLocation(@Nullable Location location) {
            this.mLocation = location;
        }

        @NonNull
        public String toString() {
            return "Metadata{mIsReversedHorizontal=" + this.mIsReversedHorizontal + ", mIsReversedVertical=" + this.mIsReversedVertical + ", mLocation=" + this.mLocation + "}";
        }
    }

    public static class OutputFileResults {
        @Nullable
        private final Uri mSavedUri;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public OutputFileResults(@Nullable Uri savedUri) {
            this.mSavedUri = savedUri;
        }

        @Nullable
        public Uri getSavedUri() {
            return this.mSavedUri;
        }
    }

    public static interface ScreenFlashUiCompleter {
        public void complete();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface FlashType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface FlashMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface CaptureMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ImageCaptureError {
    }
}

