/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.imagecapture.BundlingNode;
import androidx.camera.core.imagecapture.CaptureNode;
import androidx.camera.core.imagecapture.ProcessingNode;
import androidx.camera.core.imagecapture.ProcessingRequest;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import java.util.Objects;

@RequiresApi(api=21)
class SingleBundlingNode
implements BundlingNode {
    ProcessingRequest mPendingRequest;
    private ProcessingNode.In mOutputEdge;

    SingleBundlingNode() {
    }

    @Override
    @NonNull
    public ProcessingNode.In transform(@NonNull CaptureNode.Out captureNodeOut) {
        captureNodeOut.getImageEdge().setListener((Consumer<ImageProxy>)((Consumer)this::matchImageWithRequest));
        captureNodeOut.getPostviewImageEdge().setListener((Consumer<ImageProxy>)((Consumer)this::matchPostviewImageWithRequest));
        captureNodeOut.getRequestEdge().setListener((Consumer<ProcessingRequest>)((Consumer)this::trackIncomingRequest));
        this.mOutputEdge = ProcessingNode.In.of(captureNodeOut.getInputFormat(), captureNodeOut.getOutputFormat());
        return this.mOutputEdge;
    }

    @Override
    public void release() {
    }

    @MainThread
    private void trackIncomingRequest(final @NonNull ProcessingRequest request) {
        Threads.checkMainThread();
        Preconditions.checkState((request.getStageIds().size() == 1 ? 1 : 0) != 0, (String)"Cannot handle multi-image capture.");
        Preconditions.checkState((this.mPendingRequest == null ? 1 : 0) != 0, (String)"Already has an existing request.");
        this.mPendingRequest = request;
        Futures.addCallback(request.getCaptureFuture(), new FutureCallback<Void>(){

            @Override
            public void onSuccess(@Nullable Void result) {
            }

            @Override
            public void onFailure(@NonNull Throwable t) {
                Threads.checkMainThread();
                if (request == SingleBundlingNode.this.mPendingRequest) {
                    SingleBundlingNode.this.mPendingRequest = null;
                }
            }
        }, CameraXExecutors.directExecutor());
    }

    @MainThread
    private void matchImageWithRequest(@NonNull ImageProxy imageProxy) {
        Threads.checkMainThread();
        Preconditions.checkState((this.mPendingRequest != null ? 1 : 0) != 0);
        int stageId = (Integer)Objects.requireNonNull(imageProxy.getImageInfo().getTagBundle().getTag(this.mPendingRequest.getTagBundleKey()));
        Preconditions.checkState((stageId == this.mPendingRequest.getStageIds().get(0) ? 1 : 0) != 0);
        this.mOutputEdge.getEdge().accept(ProcessingNode.InputPacket.of(this.mPendingRequest, imageProxy));
        this.mPendingRequest = null;
    }

    @MainThread
    private void matchPostviewImageWithRequest(@NonNull ImageProxy imageProxy) {
        Threads.checkMainThread();
        if (this.mPendingRequest == null) {
            imageProxy.close();
            return;
        }
        this.mOutputEdge.getPostviewEdge().accept(ProcessingNode.InputPacket.of(this.mPendingRequest, imageProxy));
    }
}

