/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureFailure;
import androidx.camera.core.impl.CameraCaptureResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RequiresApi(value=21)
public final class CameraCaptureCallbacks {
    private CameraCaptureCallbacks() {
    }

    @NonNull
    public static CameraCaptureCallback createNoOpCallback() {
        return new NoOpCameraCaptureCallback();
    }

    @NonNull
    static CameraCaptureCallback createComboCallback(@NonNull List<CameraCaptureCallback> callbacks) {
        if (callbacks.isEmpty()) {
            return CameraCaptureCallbacks.createNoOpCallback();
        }
        if (callbacks.size() == 1) {
            return callbacks.get(0);
        }
        return new ComboCameraCaptureCallback(callbacks);
    }

    @NonNull
    public static CameraCaptureCallback createComboCallback(CameraCaptureCallback ... callbacks) {
        return CameraCaptureCallbacks.createComboCallback(Arrays.asList(callbacks));
    }

    static final class NoOpCameraCaptureCallback
    extends CameraCaptureCallback {
        NoOpCameraCaptureCallback() {
        }

        @Override
        public void onCaptureStarted() {
        }

        @Override
        public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
        }

        @Override
        public void onCaptureFailed(@NonNull CameraCaptureFailure failure) {
        }
    }

    public static final class ComboCameraCaptureCallback
    extends CameraCaptureCallback {
        private final List<CameraCaptureCallback> mCallbacks = new ArrayList<CameraCaptureCallback>();

        ComboCameraCaptureCallback(@NonNull List<CameraCaptureCallback> callbacks) {
            for (CameraCaptureCallback callback : callbacks) {
                if (callback instanceof NoOpCameraCaptureCallback) continue;
                this.mCallbacks.add(callback);
            }
        }

        @Override
        public void onCaptureStarted() {
            for (CameraCaptureCallback callback : this.mCallbacks) {
                callback.onCaptureStarted();
            }
        }

        @Override
        public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
            for (CameraCaptureCallback callback : this.mCallbacks) {
                callback.onCaptureCompleted(cameraCaptureResult);
            }
        }

        @Override
        public void onCaptureFailed(@NonNull CameraCaptureFailure failure) {
            for (CameraCaptureCallback callback : this.mCallbacks) {
                callback.onCaptureFailed(failure);
            }
        }

        @Override
        public void onCaptureCancelled() {
            for (CameraCaptureCallback callback : this.mCallbacks) {
                callback.onCaptureCancelled();
            }
        }

        @NonNull
        public List<CameraCaptureCallback> getCallbacks() {
            return this.mCallbacks;
        }

        @Override
        public void onCaptureProcessProgressed(int progress) {
            for (CameraCaptureCallback callback : this.mCallbacks) {
                callback.onCaptureProcessProgressed(progress);
            }
        }
    }
}

