/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.FocusMeteringResult;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.ForwardingCameraControl;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Set;

@RequiresApi(value=21)
public class RestrictedCameraControl
extends ForwardingCameraControl {
    public static final int ZOOM = 0;
    public static final int AUTO_FOCUS = 1;
    public static final int AF_REGION = 2;
    public static final int AE_REGION = 3;
    public static final int AWB_REGION = 4;
    public static final int FLASH = 5;
    public static final int TORCH = 6;
    public static final int EXPOSURE_COMPENSATION = 7;
    private final CameraControlInternal mCameraControl;
    private volatile boolean mUseRestrictedCameraOperations = false;
    @Nullable
    @CameraOperation
    private volatile Set<Integer> mRestrictedCameraOperations;

    public RestrictedCameraControl(@NonNull CameraControlInternal cameraControl) {
        super(cameraControl);
        this.mCameraControl = cameraControl;
    }

    public void enableRestrictedOperations(boolean enable, @Nullable @CameraOperation Set<Integer> restrictedOperations) {
        this.mUseRestrictedCameraOperations = enable;
        this.mRestrictedCameraOperations = restrictedOperations;
    }

    @Override
    @NonNull
    public CameraControlInternal getImplementation() {
        return this.mCameraControl;
    }

    boolean isOperationSupported(int ... operations) {
        if (!this.mUseRestrictedCameraOperations || this.mRestrictedCameraOperations == null) {
            return true;
        }
        ArrayList<Integer> operationList = new ArrayList<Integer>(operations.length);
        for (int operation : operations) {
            operationList.add(operation);
        }
        return this.mRestrictedCameraOperations.containsAll(operationList);
    }

    @Override
    @NonNull
    public ListenableFuture<Void> enableTorch(boolean torch) {
        if (!this.isOperationSupported(6)) {
            return Futures.immediateFailedFuture(new IllegalStateException("Torch is not supported"));
        }
        return this.mCameraControl.enableTorch(torch);
    }

    @Override
    @NonNull
    public ListenableFuture<FocusMeteringResult> startFocusAndMetering(@NonNull FocusMeteringAction action) {
        FocusMeteringAction modifiedAction = this.getModifiedFocusMeteringAction(action);
        if (modifiedAction == null) {
            return Futures.immediateFailedFuture(new IllegalStateException("FocusMetering is not supported"));
        }
        return this.mCameraControl.startFocusAndMetering(modifiedAction);
    }

    @Override
    @NonNull
    public ListenableFuture<Void> cancelFocusAndMetering() {
        return this.mCameraControl.cancelFocusAndMetering();
    }

    @Override
    @NonNull
    public ListenableFuture<Void> setZoomRatio(float ratio) {
        if (!this.isOperationSupported(0)) {
            return Futures.immediateFailedFuture(new IllegalStateException("Zoom is not supported"));
        }
        return this.mCameraControl.setZoomRatio(ratio);
    }

    @Override
    @NonNull
    public ListenableFuture<Void> setLinearZoom(float linearZoom) {
        if (!this.isOperationSupported(0)) {
            return Futures.immediateFailedFuture(new IllegalStateException("Zoom is not supported"));
        }
        return this.mCameraControl.setLinearZoom(linearZoom);
    }

    @Override
    @NonNull
    public ListenableFuture<Integer> setExposureCompensationIndex(int value) {
        if (!this.isOperationSupported(7)) {
            return Futures.immediateFailedFuture(new IllegalStateException("ExposureCompensation is not supported"));
        }
        return this.mCameraControl.setExposureCompensationIndex(value);
    }

    @Nullable
    FocusMeteringAction getModifiedFocusMeteringAction(@NonNull FocusMeteringAction action) {
        boolean shouldModify = false;
        FocusMeteringAction.Builder builder = new FocusMeteringAction.Builder(action);
        if (!action.getMeteringPointsAf().isEmpty() && !this.isOperationSupported(1, 2)) {
            shouldModify = true;
            builder.removePoints(1);
        }
        if (!action.getMeteringPointsAe().isEmpty() && !this.isOperationSupported(3)) {
            shouldModify = true;
            builder.removePoints(2);
        }
        if (!action.getMeteringPointsAwb().isEmpty() && !this.isOperationSupported(4)) {
            shouldModify = true;
            builder.removePoints(4);
        }
        if (!shouldModify) {
            return action;
        }
        FocusMeteringAction modifyAction = builder.build();
        if (modifyAction.getMeteringPointsAf().isEmpty() && modifyAction.getMeteringPointsAe().isEmpty() && modifyAction.getMeteringPointsAwb().isEmpty()) {
            return null;
        }
        return builder.build();
    }

    public static @interface CameraOperation {
    }
}

